/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity.ai;

import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.config.AI;
import com.vetpetmon.wyrmsofnyrus.common.entity.MobEntityBase;
import com.vetpetmon.wyrmsofnyrus.common.locallib.DifficultyStats;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.MobEffects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class ScreamAI
extends EntityAIAttackMelee {
    protected float range;
    protected double posX;
    protected double posZ;
    private MobEntityBase entity;
    private int attackingTicks;
    private int timeToPerform;
    protected SoundEvent sound;

    public ScreamAI(MobEntityBase creature, double speedIn, boolean useLongMemory, float attackRange, int timeToPerform, SoundEvent sound) {
        super((EntityCreature)creature, speedIn, useLongMemory);
        this.entity = creature;
        this.range = attackRange;
        this.timeToPerform = timeToPerform;
        this.sound = sound;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.attackingTicks = 0;
        this.entity.setAttack(0);
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.attackingTicks = 0;
        this.entity.func_184185_a(this.sound, 1.4f, 1.15f);
        this.posX = this.entity.field_70165_t;
        this.posZ = this.entity.field_70161_v;
    }

    public boolean func_75253_b() {
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        if (this.timeToPerform < this.attackingTicks) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75246_d() {
        super.func_75246_d();
        ++this.attackingTicks;
        if (this.attackingTicks >= 1 && this.field_75439_d < this.timeToPerform) {
            this.entity.setAttack(12);
        } else {
            this.entity.setAttack(0);
        }
    }

    protected void func_190102_a(EntityLivingBase target, double p_190102_2_) {
        if (this.timeToPerform > this.attackingTicks) {
            this.entity.field_70165_t = this.posX;
            this.entity.field_70161_v = this.posZ;
            WyrmsOfNyrus.logger.debug("pausing entity movement");
            if (this.entity.func_70638_az() != null && this.entity.func_70638_az() instanceof EntityLiving) {
                EntityLiving entityTarget = (EntityLiving)this.entity.func_70638_az();
                List nearbyMobs = this.entity.func_130014_f_().func_72872_a(EntityMob.class, new AxisAlignedBB(this.posX - (double)this.range, this.entity.field_70163_u - (double)(this.range / 2.0f), this.posZ - (double)this.range, this.posX + (double)this.range, this.entity.field_70163_u + (double)(this.range / 2.0f), this.posZ + (double)this.range));
                if (!nearbyMobs.isEmpty()) {
                    for (EntityMob ent : nearbyMobs) {
                        if (!(ent instanceof EntityCreeper)) {
                            ent.func_70624_b((EntityLivingBase)entityTarget);
                        }
                        if (!(ent instanceof EntityCreeper) || !AI.psychicsAreFun) continue;
                        ent.func_70624_b((EntityLivingBase)entityTarget);
                    }
                }
                DifficultyStats.applyPotionEffect((Entity)entityTarget, MobEffects.field_76440_q, 40, 0, true);
                DifficultyStats.applyPotionEffect((Entity)entityTarget, MobEffects.field_76421_d, 10, 2, true);
            }
        }
    }

    protected double func_179512_a(EntityLivingBase attackTarget) {
        return this.field_75441_b.field_70130_N * (this.range / 2.0f) * this.field_75441_b.field_70130_N * (this.range / 2.0f) + attackTarget.field_70130_N;
    }
}

