/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity.worm;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.vetpetmon.wyrmsofnyrus.common.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.entity.worm.BurrowingEntity;
import com.vetpetmon.wyrmsofnyrus.common.locallib.StatType;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WormEntity
extends BurrowingEntity {
    public double wayX;
    public double wayY;
    public double wayZ;
    public double courseChangeCooldown = 0.0;
    public double agroCD = 0.0;
    protected Entity targetedEntity = null;
    protected int surY;
    protected int attackTick;
    protected int dmgCD = 0;
    protected double bodySPD;
    protected double maxBodySPD;
    protected double partDIST;
    protected double KBD;
    protected double ySPD;
    protected double SPD;
    protected double atkDIST;
    protected double partRANGE;
    protected EntityLivingBase connection;
    protected BlockPos start = new BlockPos(0, 0, 0);
    protected boolean canFly = false;
    protected boolean nearGround;
    protected boolean performedCheck;
    private int headID;
    private int segmentID;
    public static final Predicate<Entity> wormSelector = target -> target instanceof WormEntity;

    public WormEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.surY = 60;
    }

    public int getSegmentID() {
        return this.segmentID;
    }

    public void setSegmentID(int num) {
        this.segmentID = num;
    }

    public Entity getHead() {
        return this.field_70170_p.func_73045_a(this.headID);
    }

    public int getHeadID() {
        return this.headID;
    }

    public void setHeadID(int id) {
        this.headID = id;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("wormID", this.getHeadID());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHeadID(compound.func_74762_e("wormID"));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityWyrm || source.func_76364_f() instanceof EntityWyrm) {
            return false;
        }
        if (this.func_180431_b(source) || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source.func_76364_f() instanceof WormEntity && ((WormEntity)source.func_76364_f()).headID == this.headID) {
            return false;
        }
        float amt = amount;
        if (!this.isHead()) {
            amt /= 3.0f;
        }
        if (source.func_76364_f() != null) {
            this.func_130011_c(Objects.requireNonNull(source.func_76364_f()));
        }
        return super.func_70097_a(source, amt);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.isHead() && this.targetedEntity != null && this.targetedEntity instanceof EntityPlayer) {
            this.field_70708_bq = 0;
        }
        if (this.field_70163_u < -10.0) {
            this.func_70634_a(this.field_70165_t, 128.0, this.field_70161_v);
            this.field_70181_x = 0.0;
        } else if (this.field_70163_u < 3.0) {
            this.field_70181_x = 0.3;
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        if (this.attackTick == 0) {
            this.attackTick = 10;
            this.atkTargeter(this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5), Predicates.and((Predicate)EntitySelectors.field_180132_d, e -> e instanceof EntityLivingBase)));
        }
    }

    protected void atkTargeter(List<Entity> targets) {
        for (Entity ent : targets) {
            if (!(ent instanceof EntityLivingBase) || !this.func_70686_a(((EntityLivingBase)ent).getClass()) || ent instanceof WormEntity && ((WormEntity)ent).getHeadID() == this.getHeadID()) continue;
            this.func_70652_k(ent);
        }
    }

    @Override
    public boolean func_70652_k(Entity target) {
        if (target instanceof EntityWyrm) {
            return false;
        }
        boolean atk = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getATKPower());
        if (atk) {
            this.field_70708_bq = 0;
            double tx = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
            double ty = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
            double tz = (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0;
            double deltaX = target.field_70165_t - tx;
            double deltaY = target.field_70161_v - ty;
            double deltaZ = target.field_70163_u - tz;
            double knockback = this.KBD * (deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ + 0.1);
            target.func_70024_g(deltaX / knockback, deltaY / knockback, deltaZ / knockback);
        }
        return atk;
    }

    private float getATKPower() {
        if (this.isHead()) {
            if (Radiogenetics.dontEatMe) {
                return this.getMatrix().getStat(StatType.ATTACK) * 3.0f;
            }
            return 1000.0f;
        }
        return this.getMatrix().getStat(StatType.ATTACK);
    }

    protected boolean cantTraverse() {
        return this.canFly || this.inBlock();
    }
}

