/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity.wyrms;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.config.AI;
import com.vetpetmon.wyrmsofnyrus.common.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.entity.ability.CreepedEvents;
import com.vetpetmon.wyrmsofnyrus.common.entity.ability.creepTheLands;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.ScreamAI;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.SprinterAttackAI;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.gestalt.GestaltHostMind;
import com.vetpetmon.wyrmsofnyrus.common.handlers.LootTables;
import com.vetpetmon.wyrmsofnyrus.common.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.common.locallib.StatType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityFungallid
extends EntityWyrm {
    private int timeToInfest;
    public static int[] legalVarInts = new int[]{0, 7, 9, 17, 20};

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.fungallidStatMatrix;
    }

    public EntityFungallid(World world) {
        super(world);
        this.casteType = 2;
        this.func_70105_a(0.8f, 1.0f);
        this.field_70728_aV = 6;
        this.func_110163_bv();
        this.setLegalVariants(legalVarInts);
        this.func_94061_f(false);
        this.setRadAuraRadius(2.0);
        this.setPotency(6.0);
        this.withID(this, 18);
        this.timeToInfest = WyrmStats.fungallidInfectivitySeverity * 20;
    }

    public boolean playerNearby() {
        boolean b = false;
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.getDetectionRange());
        if (!players.isEmpty()) {
            for (EntityPlayer player : players) {
                if (player.func_70093_af()) {
                    if (!(this.func_70032_d((Entity)player) >= 21.0f)) continue;
                    b = true;
                    break;
                }
                if (!this.func_70613_aW()) continue;
                this.func_70624_b((EntityLivingBase)player);
            }
        }
        return b;
    }

    private AxisAlignedBB getDetectionRange() {
        return new AxisAlignedBB(this.field_70165_t - 30.0, this.field_70163_u - 30.0, this.field_70161_v - 30.0, this.field_70165_t + 30.0, this.field_70163_u + 30.0, this.field_70161_v + 30.0);
    }

    @Override
    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        CreepedEvents.newConvertEvent((Entity)entity, (Entity)this);
        if (AI.maxInfamyDoublesCreepedSpawns && GestaltHostMind.infamyIsMaxed) {
            CreepedEvents.convertKill((Entity)entity, (Entity)this);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.SOLDIER_LOOT_TABLE;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.afterPlayers(true);
        this.afterAnimals();
        this.afterVillagers();
        this.afterMobs();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SprinterAttackAI(this, 0.75, true, this.getMatrix().getStat(StatType.SPEED) * 2.0f, SoundRegistry.fungallidscream));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ScreamAI(this, 0.0, true, 20.0f, 40, SoundRegistry.fungallidscream));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("GrowthTime")) {
            this.timeToInfest = compound.func_74762_e("timeToInfest");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("timeToInfest", this.timeToInfest);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        --this.timeToInfest;
        if (this.timeToInfest <= 0) {
            creepTheLands.creepTheLands(this.func_180425_c(), this.field_70170_p, WyrmStats.fungallidInfectivity, (Entity)this, true);
            this.timeToInfest = WyrmStats.fungallidInfectivitySeverity * 20;
            WyrmsOfNyrus.logger.debug("Fungallid attempted to infest a block.");
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    protected float func_175134_bD() {
        if (this.getAttack() == 2) {
            return 0.75f;
        }
        return 0.45f;
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.fungallidliving;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundRegistry.wyrmHissTwo;
    }

    public SoundEvent func_184615_bR() {
        return SoundRegistry.fungalliddeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.wyrmSteps, 0.5f, 0.5f);
    }
}

