/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity.wyrms;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.common.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityHitbox;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.EntityAIHarvester;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionPoints;
import com.vetpetmon.wyrmsofnyrus.common.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.common.world.structures.StructureConstruct;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWyrmGrunt
extends EntityWyrm {
    public int timeUntilNextProduct;
    public int timeUntilNextTask;
    public boolean isTasked;
    public static int[] legalVarInts = new int[]{0, 4, 5, 7, 9, 14, 15, 16, 17, 20, 21, 25, 26, 27, 28};
    public EntityHitbox tail;
    public EntityHitbox tail1;
    public EntityHitbox head;
    public EntityHitbox arm1;
    public EntityHitbox arm2;
    protected Task currentTask;

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.gruntStatMatrix;
    }

    public EntityWyrmGrunt(World world) {
        super(world);
        this.casteType = 2;
        this.func_70105_a(2.0f, 2.8f);
        this.field_70728_aV = 35;
        this.func_110163_bv();
        this.func_94061_f(false);
        this.setLegalVariants(legalVarInts);
        this.func_98053_h(true);
        this.timeUntilNextProduct = this.field_70146_Z.nextInt(6000) + Radiogenetics.workerProductivity;
        this.timeUntilNextTask = 100;
        this.isTasked = false;
        this.setPotency(13.5);
        this.withID(this, 25);
        this.tail = new EntityHitbox((EntityLiving)this, 1.6f, -3.2f, 0.25f, 1.25f, 1.25f, 0.25f);
        this.tail1 = new EntityHitbox((EntityLiving)this, 1.6f, -1.75f, 0.35f, 1.5f, 1.5f, 0.5f);
        this.head = new EntityHitbox((EntityLiving)this, -1.6f, -1.0f, 2.4f, 1.7f, 1.4f, 1.2f);
        this.arm1 = new EntityHitbox((EntityLiving)this, -0.45f, -1.65f, 0.8f, 1.0f, 2.2f, 0.8f);
        this.arm2 = new EntityHitbox((EntityLiving)this, -2.5f, -1.65f, 0.8f, 1.0f, 2.2f, 0.8f);
        this.hitboxes = new EntityHitbox[]{this.tail, this.tail1, this.head, this.arm1, this.arm2};
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIHarvester((EntityLiving)this, 160, 3, 2, WyrmStats.gruntBreakBLBlocks));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.afterPlayers();
        if (EntityWyrmGrunt.getAttackVillagers()) {
            this.afterVillagers();
        }
        this.afterMobs();
    }

    @Override
    protected boolean canEnrage() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.deepwyrmclicks;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundRegistry.soldierhurt;
    }

    public SoundEvent func_184615_bR() {
        return SoundRegistry.soldierdeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 2.0f, 0.7f);
        WyrmsOfNyrus.proxy.ScreamScreenShake(this, 0.5f, 1.0f, true);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && --this.timeUntilNextTask <= 0) {
            int roll = RNG.dBase((int)10);
            switch (roll) {
                case 1: {
                    this.isTasked = true;
                    this.setCurrentTask(Task.TUNNEL);
                    List nearbyWorkers = this.field_70170_p.func_72872_a(EntityWyrmGrunt.class, new AxisAlignedBB(this.field_70165_t - 36.0, this.field_70163_u - 36.0, this.field_70161_v - 36.0, this.field_70165_t + 36.0, this.field_70163_u + 36.0, this.field_70161_v + 36.0));
                    if (nearbyWorkers.isEmpty()) break;
                    for (EntityWyrmGrunt ent : nearbyWorkers) {
                        if (ent.isTasked) continue;
                        ent.isTasked = true;
                        ent.setCurrentTask(Task.TUNNEL);
                        ent.timeUntilNextTask = this.timeUntilNextTask;
                        ent.field_70177_z = this.field_70177_z;
                        ent.field_70125_A = this.field_70125_A;
                        ent.field_70759_as = this.field_70759_as;
                        ent.func_191986_a(this.field_70702_br, this.field_70701_bs, 1.5f);
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.isTasked = true;
                    this.setCurrentTask(Task.BUILD);
                    break;
                }
                default: {
                    this.isTasked = false;
                    this.setCurrentTask(Task.NONE);
                }
            }
            this.timeUntilNextTask = this.field_70146_Z.nextInt(1000) + Radiogenetics.workerProductivity;
        }
        if (this.getCurrentTask() == Task.TUNNEL) {
            this.func_191986_a(this.field_70702_br, this.field_70701_bs, 1.5f);
        } else if (this.getCurrentTask() == Task.BUILD && this.field_70173_aa % 1600 == 0 && RNG.getIntRangeInclu((int)0, (int)30) == 1) {
            if (this.field_70163_u < (double)(this.func_130014_f_().func_181545_F() - 12) && !this.field_70170_p.field_72995_K) {
                if (this.field_70163_u > 9.0) {
                    int structureID = RNG.getIntRangeInclu((int)1, (int)5);
                    StructureConstruct structure = new StructureConstruct("workerbasic/worker_structureu" + structureID, true);
                    int cost = structure.getResourceCost(this.func_130014_f_());
                    if (cost <= InvasionPoints.getResources(this.func_130014_f_())) {
                        BlockPos randomPosition = new BlockPos(this.field_70165_t + (double)RNG.getIntRangeInclu((int)-10, (int)10), this.field_70163_u, this.field_70161_v + (double)RNG.getIntRangeInclu((int)-10, (int)10));
                        InvasionPoints.removeResources(this.func_130014_f_(), cost);
                        structure.func_180709_b(this.func_130014_f_(), this.field_70146_Z, randomPosition);
                        WyrmsOfNyrus.logger.debug("Attempted to build worker_structureu{}", (Object)structureID);
                    }
                }
            } else if (!this.field_70170_p.field_72995_K && this.field_70163_u > (double)this.func_130014_f_().func_181545_F() && this.field_70163_u < (double)(this.func_130014_f_().func_72800_K() - 25)) {
                BlockPos randomPosition = new BlockPos(this.field_70165_t + (double)RNG.getIntRangeInclu((int)-10, (int)10), this.field_70163_u + (double)RNG.getIntRangeInclu((int)-1, (int)2), this.field_70161_v + (double)RNG.getIntRangeInclu((int)-10, (int)10));
                int structureID = RNG.getIntRangeInclu((int)1, (int)7);
                StructureConstruct structure = new StructureConstruct("workerbasic/worker_structure" + structureID, true);
                int cost = structure.getResourceCost(this.func_130014_f_());
                if (cost <= InvasionPoints.getResources(this.func_130014_f_())) {
                    InvasionPoints.removeResources(this.func_130014_f_(), cost);
                    structure.func_180709_b(this.func_130014_f_(), this.field_70146_Z, randomPosition);
                    WyrmsOfNyrus.logger.debug("Attempted to build worker_structure{}", (Object)structureID);
                }
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProductionTime")) {
            this.timeUntilNextProduct = compound.func_74762_e("ProductionTime");
        }
        if (compound.func_74764_b("TaskTime")) {
            this.timeUntilNextTask = compound.func_74762_e("TaskTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ProductionTime", this.timeUntilNextProduct);
        compound.func_74768_a("TaskTime", this.timeUntilNextTask);
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.currentTask = currentTask;
    }

    public static enum Task {
        NONE,
        TUNNEL,
        BUILD,
        COMBINE;

    }
}

