/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity.wyrms;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.config.AI;
import com.vetpetmon.wyrmsofnyrus.common.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.common.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.EntityAIHarvester;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityMyrmur;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityWyrmGrunt;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityWyrmRover;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityWyrmSoldier;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityWyrmWarrior;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionPoints;
import com.vetpetmon.wyrmsofnyrus.common.item.AllItems;
import com.vetpetmon.wyrmsofnyrus.common.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.common.locallib.RangeCheck;
import com.vetpetmon.wyrmsofnyrus.common.world.structures.StructureConstruct;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWyrmWorker
extends EntityWyrm {
    public int timeUntilNextProduct;
    public int timeUntilNextTask;
    public int unitsCollected;
    public boolean unionizing;
    public boolean isTasked;
    public static int[] legalVarInts = new int[]{0, 4, 5, 7, 9, 14, 15, 16, 17, 18, 20};
    protected Task currentTask;

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.workerStatMatrix;
    }

    public EntityWyrmWorker(World world) {
        super(world);
        this.casteType = 2;
        this.func_70105_a(0.85f, 1.5f);
        this.field_70728_aV = 1;
        this.func_110163_bv();
        this.func_94061_f(false);
        this.setLegalVariants(legalVarInts);
        this.func_98053_h(true);
        this.timeUntilNextProduct = this.field_70146_Z.nextInt(6000) + Radiogenetics.workerProductivity;
        this.timeUntilNextTask = 100;
        this.unionizing = false;
        this.isTasked = false;
        this.setPotency(3.5);
        this.withID(this, 4);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.getInvasionDifficulty() >= 3.0 && AI.savageAIMode || this.unionizing) {
            this.afterPlayers();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
            this.simpleAI();
        } else {
            this.simpleAI();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        }
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIHarvester((EntityLiving)this, 60, 3, 1, WyrmStats.workerBreakBLBlocks));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    protected boolean canEnrage() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.wyrmClicks;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundRegistry.wyrmHissTwo;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.wyrmSteps, 1.0f, 1.0f);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (--this.timeUntilNextProduct <= 0) {
                if (!RangeCheck.blocks(this.field_70170_p, this.func_180425_c(), 4.0, "minecraft:hopper")) {
                    this.func_184185_a(SoundEvents.field_187665_Y, 0.25f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    this.func_145779_a(AllItems.metalcomb_array, 1);
                } else {
                    this.func_184185_a(SoundRegistry.wyrmHissTwo, 1.0f, 0.25f);
                    this.unionizing = true;
                }
                this.timeUntilNextProduct = this.field_70146_Z.nextInt(6000) + Radiogenetics.workerProductivity;
            }
            if (--this.timeUntilNextTask <= 0) {
                int roll = RNG.dBase((int)10);
                switch (roll) {
                    case 1: {
                        this.isTasked = true;
                        this.setCurrentTask(Task.TUNNEL);
                        List nearbyWorkers = this.field_70170_p.func_72872_a(EntityWyrmWorker.class, new AxisAlignedBB(this.field_70165_t - 36.0, this.field_70163_u - 36.0, this.field_70161_v - 36.0, this.field_70165_t + 36.0, this.field_70163_u + 36.0, this.field_70161_v + 36.0));
                        if (nearbyWorkers.isEmpty()) break;
                        Iterator iterator = nearbyWorkers.iterator();
                        while (iterator.hasNext()) {
                            EntityWyrmWorker ent = (EntityWyrmWorker)iterator.next();
                            if (ent.isTasked) continue;
                            ent.isTasked = true;
                            ent.setCurrentTask(Task.TUNNEL);
                            ent.timeUntilNextTask = this.timeUntilNextTask;
                            ent.field_70177_z = this.field_70177_z;
                            ent.field_70125_A = this.field_70125_A;
                            ent.field_70759_as = this.field_70759_as;
                            ent.func_191986_a(this.field_70702_br, this.field_70701_bs, 1.5f);
                        }
                        break;
                    }
                    case 2: {
                        this.isTasked = true;
                        this.setCurrentTask(Task.COMBINE);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.isTasked = true;
                        this.setCurrentTask(Task.BUILD);
                        break;
                    }
                    default: {
                        this.isTasked = false;
                        this.setCurrentTask(Task.NONE);
                    }
                }
                this.timeUntilNextTask = this.field_70146_Z.nextInt(1000) + Radiogenetics.workerProductivity;
            }
        }
        if (this.getCurrentTask() == Task.TUNNEL) {
            this.func_191986_a(this.field_70702_br, this.field_70701_bs, 1.5f);
        }
        if (this.getCurrentTask() == Task.COMBINE) {
            List nearbyWyrms;
            if (this.field_70173_aa % 200 == 0 && !(nearbyWyrms = this.field_70170_p.func_72872_a(EntityWyrm.class, new AxisAlignedBB(this.field_70165_t - 6.0, this.field_70163_u - 6.0, this.field_70161_v - 6.0, this.field_70165_t + 6.0, this.field_70163_u + 6.0, this.field_70161_v + 6.0))).isEmpty()) {
                for (EntityWyrm ent : nearbyWyrms) {
                    if (ent == null || ent == this || this.unitsCollected >= WyrmStats.workerToGrunt || !(ent instanceof EntityWyrmSoldier) && !(ent instanceof EntityWyrmRover) && !(ent instanceof EntityWyrmWorker) && !(ent instanceof EntityWyrmWarrior) && !(ent instanceof EntityMyrmur)) continue;
                    ++this.unitsCollected;
                    ent.func_70106_y();
                }
            }
            if (this.unitsCollected >= WyrmStats.workerToGrunt && !this.field_70170_p.field_72995_K) {
                EntityWyrmGrunt entityToSpawn = new EntityWyrmGrunt(this.field_70170_p);
                entityToSpawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                entityToSpawn.setVariant(this.getVariantIndex());
                this.field_70170_p.func_72838_d((Entity)entityToSpawn);
                this.func_70106_y();
            }
        } else if (this.getCurrentTask() == Task.BUILD && this.field_70173_aa % 1600 == 0 && RNG.getIntRangeInclu((int)0, (int)30) == 1) {
            if (this.field_70163_u < (double)(this.func_130014_f_().func_181545_F() - 12) && !this.field_70170_p.field_72995_K) {
                if (this.field_70163_u > 9.0) {
                    int structureID = RNG.getIntRangeInclu((int)1, (int)5);
                    StructureConstruct structure = new StructureConstruct("workerbasic/worker_structureu" + structureID, true);
                    int cost = structure.getResourceCost(this.func_130014_f_());
                    if (cost <= InvasionPoints.getResources(this.func_130014_f_())) {
                        BlockPos randomPosition = new BlockPos(this.field_70165_t + (double)RNG.getIntRangeInclu((int)-10, (int)10), this.field_70163_u, this.field_70161_v + (double)RNG.getIntRangeInclu((int)-10, (int)10));
                        InvasionPoints.removeResources(this.func_130014_f_(), cost);
                        structure.func_180709_b(this.func_130014_f_(), this.field_70146_Z, randomPosition);
                        WyrmsOfNyrus.logger.debug("Attempted to build worker_structureu{}", (Object)structureID);
                    }
                }
            } else if (!this.field_70170_p.field_72995_K && this.field_70163_u > (double)this.func_130014_f_().func_181545_F() && this.field_70163_u < (double)(this.func_130014_f_().func_72800_K() - 25)) {
                BlockPos randomPosition = new BlockPos(this.field_70165_t + (double)RNG.getIntRangeInclu((int)-10, (int)10), this.field_70163_u + (double)RNG.getIntRangeInclu((int)-1, (int)2), this.field_70161_v + (double)RNG.getIntRangeInclu((int)-10, (int)10));
                int structureID = RNG.getIntRangeInclu((int)1, (int)7);
                StructureConstruct structure = new StructureConstruct("workerbasic/worker_structure" + structureID, true);
                int cost = structure.getResourceCost(this.func_130014_f_());
                if (cost <= InvasionPoints.getResources(this.func_130014_f_())) {
                    InvasionPoints.removeResources(this.func_130014_f_(), cost);
                    structure.func_180709_b(this.func_130014_f_(), this.field_70146_Z, randomPosition);
                    WyrmsOfNyrus.logger.debug("Attempted to build worker_structure{}", (Object)structureID);
                }
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProductionTime")) {
            this.timeUntilNextProduct = compound.func_74762_e("ProductionTime");
        }
        if (compound.func_74764_b("unionizing")) {
            this.unionizing = compound.func_74767_n("unionizing");
        }
        if (compound.func_74764_b("TaskTime")) {
            this.timeUntilNextTask = compound.func_74762_e("TaskTime");
        }
        this.unitsCollected = compound.func_74762_e("collected");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ProductionTime", this.timeUntilNextProduct);
        compound.func_74768_a("TaskTime", this.timeUntilNextTask);
        compound.func_74757_a("unionizing", this.unionizing);
        compound.func_74768_a("collected", this.unitsCollected);
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.currentTask = currentTask;
    }

    public static enum Task {
        NONE,
        TUNNEL,
        BUILD,
        COMBINE;

    }
}

