/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.handlers;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.common.config.Modifiers;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class WoNSpawner {
    protected static WoNSpawner INSTANCE;
    private static int PurgedSpawned;
    private int timer = 0;
    private int timerBetweenSpawns = 200;
    public static List<EntityWyrm> WyrmsWithPurgedVariant;

    public static int getPurgedSpawned() {
        return PurgedSpawned;
    }

    public static void resetPurgedSpawned() {
        PurgedSpawned = 0;
    }

    public static void addPurgedSpawned() {
        ++PurgedSpawned;
    }

    public static WoNSpawner getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WoNSpawner();
        }
        return INSTANCE;
    }

    public boolean CanSpawnPurged(World world) {
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL || !Modifiers.PURGEDACTIVE) {
            return false;
        }
        if (WoNSpawner.getPurgedSpawned() > WoNVars.worldVariables.getWyrmsKilled(world)) {
            return false;
        }
        return !world.func_72935_r() && WoNSpawner.getPurgedSpawned() < Modifiers.PURGEDHARDCAP;
    }

    private BlockPos getSafeSpawnPos(EntityLivingBase entity, BlockPos near) {
        int radius = 6;
        int maxTries = 24;
        for (int i = 0; i < maxTries; ++i) {
            int x = near.func_177958_n() + entity.func_130014_f_().field_73012_v.nextInt(radius * 2) - radius;
            int z = near.func_177952_p() + entity.func_130014_f_().field_73012_v.nextInt(radius * 2) - radius;
            int y = entity.func_130014_f_().func_189649_b(x, z) + 16;
            BlockPos testing = new BlockPos(x, y, z);
            while (entity.func_130014_f_().func_175623_d(testing) && testing.func_177956_o() > 0) {
                testing = testing.func_177979_c(1);
            }
            IBlockState iblockstate = entity.func_130014_f_().func_180495_p(testing);
            if (!iblockstate.func_189884_a((Entity)entity)) continue;
            return testing.func_177981_b(1);
        }
        return null;
    }

    private EntityWyrm getPurgedWyrm(World world) {
        return WyrmsWithPurgedVariant.get(RNG.getIntRangeInclu((int)0, (int)WyrmsWithPurgedVariant.size()));
    }

    public void performPurgedSpawn(World world, EntityPlayer player) {
        if (this.CanSpawnPurged(world) && !world.field_73010_i.isEmpty() && player != null) {
            ++this.timer;
            if (this.timer >= this.timerBetweenSpawns) {
                Random rand = player.field_70170_p.field_73012_v;
                BlockPos safePos = this.getSafeSpawnPos((EntityLivingBase)this.getPurgedWyrm(world), player.func_180425_c());
                this.timer = 0;
            }
        }
    }

    static {
        PurgedSpawned = 0;
    }
}

