/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.invasion;

import com.vetpetmon.synlib.core.util.BlockUtils;
import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.block.AllBlocks;
import com.vetpetmon.wyrmsofnyrus.common.block.BlockMaterials;
import com.vetpetmon.wyrmsofnyrus.common.block.hivecreep.BlockHivecreepPillar;
import com.vetpetmon.wyrmsofnyrus.common.block.hivecreep.creepStaged;
import com.vetpetmon.wyrmsofnyrus.common.compat.SRP;
import com.vetpetmon.wyrmsofnyrus.common.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.common.config.WorldConfig;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionPoints;
import com.vetpetmon.wyrmsofnyrus.common.locallib.networkmessages.BiomeChange;
import com.vetpetmon.wyrmsofnyrus.common.locallib.networkmessages.MessageReg;
import com.vetpetmon.wyrmsofnyrus.common.world.biome.BiomeRegistry;
import com.vetpetmon.wyrmsofnyrus.common.world.biome.SpreadingBiome;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HiveCreepSpreadFurther {
    public static boolean creepspreadRules(BlockPos i, World world, BlockPos OG) {
        boolean isUnAllowedBlock;
        boolean isAir = world.func_175623_d(i);
        boolean isSoft = world.func_180495_p(i).func_185887_b(world, i) < Invasion.creepSpreadMaxHardness;
        boolean isFullCube = world.func_180495_p(i).func_185917_h();
        boolean bl = isUnAllowedBlock = Invasion.invalidBlocks.contains(world.func_180495_p(i).func_177230_c()) || HiveCreepSpreadFurther.matLookingBlock(i, BlockMaterials.CREEP, world) || HiveCreepSpreadFurther.matLookingBlock(i, BlockMaterials.WYRM, world) || world.func_180495_p(i).func_177230_c() == Block.func_149684_b((String)"wyrmsofnyrus:creepedgrass") || world.func_180495_p(i).func_177230_c() == Block.func_149684_b((String)"wyrmsofnyrus:corium");
        if (Invasion.CSBlockBLEnabled && !i.equals((Object)OG)) {
            return !isAir && isSoft && isFullCube && !isUnAllowedBlock;
        }
        return !isAir && isSoft && isFullCube && !isUnAllowedBlock;
    }

    public static void decay(BlockPos pos, World world, Block decayInto) {
        BlockPos posy = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        if (decayInto == AllBlocks.hiveStone && RNG.dBase((int)WorldConfig.hivesteelOreChance) == 1) {
            decayInto = AllBlocks.hiveSteelOre;
        }
        if (RNG.getIntRangeInclu((int)0, (int)Math.max(1, Invasion.creepInactivityChance)) <= 1) {
            world.func_180501_a(pos, decayInto.func_176223_P(), 3);
            Random rand = new Random();
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            world.func_184133_a(null, pos, SoundRegistry.creepSpread, SoundCategory.BLOCKS, 1.0f, 0.25f);
            if (Invasion.creepBlocksProduceGas && world.func_175623_d(posy)) {
                world.func_180501_a(posy, AllBlocks.radioactivegas.func_176223_P(), 3);
            }
            if (WorldConfig.creepedBiomeEnabled && (world.func_175678_i(pos.func_177984_a()) || world.func_175623_d(pos.func_177981_b(5)))) {
                for (int i = -1; i <= 1; ++i) {
                    for (int y = -1; y <= 1; ++y) {
                        BlockPos spreadPos = new BlockPos(pos.func_177958_n() + i, 1, pos.func_177952_p() + y);
                        SpreadingBiome.setBiome(world, spreadPos);
                        MessageReg.CHANNEL.sendToDimension((IMessage)new BiomeChange(spreadPos), world.field_73011_w.getDimension());
                    }
                }
            }
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                Biome biomeCheck = world.func_180494_b(pos);
                if (biomeCheck == BiomeRegistry.CREEPLANDS) {
                    SpreadingBiome.createCreepedStructure(world, pos.func_177984_a(), world.field_73012_v);
                } else if (biomeCheck == BiomeRegistry.COOLEDCREEPLANDS) {
                    if (RNG.getIntRangeInclu((int)0, (int)1) == 0) {
                        SpreadingBiome.createCreepedStructure(world, pos.func_177984_a(), world.field_73012_v);
                    } else {
                        SpreadingBiome.createCoolantStructure(world, pos.func_177984_a(), world.field_73012_v);
                    }
                } else if (RNG.getIntRangeInclu((int)0, (int)2) == 0) {
                    SpreadingBiome.createCreepedStructure(world, pos.func_177984_a(), world.field_73012_v);
                } else {
                    SpreadingBiome.createHexedStructure(world, pos.func_177984_a(), world.field_73012_v);
                }
            }
        }
    }

    public static void addPoints(World world) {
        InvasionPoints.add(world, Invasion.creepSpreadPoints);
        WyrmsOfNyrus.logger.debug("Invasion points increased by " + Invasion.creepSpreadPoints + " from creep spread");
    }

    public static boolean checkIfValid(BlockPos pos, World world, BlockPos OG) {
        boolean isUnAllowedBlock;
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return true;
        }
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (world.func_180495_p(pos) instanceof BlockContainer) {
            return false;
        }
        if (world.func_180495_p(pos).func_185887_b(world, pos) > Invasion.creepSpreadMaxHardness) {
            return false;
        }
        if (!world.func_180495_p(pos).func_185917_h()) {
            return false;
        }
        boolean bl = isUnAllowedBlock = HiveCreepSpreadFurther.matAtBlock(pos, world) == BlockMaterials.WYRM || HiveCreepSpreadFurther.matAtBlock(pos, world) == BlockMaterials.CREEP || world.func_180495_p(pos).func_177230_c() == Block.func_149684_b((String)"wyrmsofnyrus:creepedgrass") || world.func_180495_p(pos).func_177230_c() == Block.func_149684_b((String)"wyrmsofnyrus:corium");
        if (Invasion.CSBlockBLEnabled && !pos.equals((Object)OG)) {
            return !isUnAllowedBlock && !Invasion.invalidBlocks.contains(world.func_180495_p(pos).func_177230_c());
        }
        return !isUnAllowedBlock && !pos.equals((Object)OG);
    }

    public static void spread(BlockPos pos, World world, Block decayInto) {
        if (!Invasion.isCreepEnabled()) {
            return;
        }
        if (RNG.getIntRangeInclu((int)0, (int)Math.max(1, Invasion.creepSpreadRate)) != 1) {
            return;
        }
        int Range = 1;
        block24: for (int i = 0; i < 4; ++i) {
            IBlockState block;
            int z;
            int y;
            int x = pos.func_177958_n() + RNG.getIntRangeInclu((int)(-Range), (int)Range);
            BlockPos posi = new BlockPos(x, y = pos.func_177956_o() + RNG.getIntRangeInclu((int)(-Range), (int)Range), z = pos.func_177952_p() + RNG.getIntRangeInclu((int)(-Range), (int)Range));
            if (!HiveCreepSpreadFurther.checkIfValid(posi, world, pos) || HiveCreepSpreadFurther.matAtBlock(block = HiveCreepSpreadFurther.blockStateAtPos(posi, world)).func_76224_d()) continue;
            if (block.func_177230_c().getRegistryName() != null) {
                if (block.func_177230_c().getRegistryName().toString().equals("minecraft:glowstone")) {
                    if (RNG.getIntRangeInclu((int)0, (int)1) == 1) {
                        world.func_180501_a(posi, AllBlocks.wyrm_lights_yellow.func_176223_P(), 3);
                    } else {
                        world.func_180501_a(posi, AllBlocks.wyrm_lights_orange.func_176223_P(), 3);
                    }
                    HiveCreepSpreadFurther.addPoints(world);
                }
                if (SRP.isEnabled() && WorldConfig.vileEnabled && HiveCreepSpreadFurther.getBlockModName(block).equals("srparasites")) {
                    world.func_180501_a(posi, AllBlocks.corium.func_176223_P(), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                }
                switch (block.func_177230_c().getRegistryName().func_110623_a()) {
                    case "gold_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownedgold.func_176223_P(), 3);
                        return;
                    }
                    case "iron_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownediron.func_176223_P(), 3);
                        return;
                    }
                    case "coal_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownedcoal.func_176223_P(), 3);
                        return;
                    }
                    case "lapis_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownedlapis.func_176223_P(), 3);
                        return;
                    }
                    case "diamond_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdowneddiamond.func_176223_P(), 3);
                        return;
                    }
                    case "emerald_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownedemerald.func_176223_P(), 3);
                        return;
                    }
                    case "redstone_ore": {
                        world.func_180501_a(posi, AllBlocks.meltdownedredstone.func_176223_P(), 3);
                        return;
                    }
                }
            }
            if (block instanceof BlockLog) {
                world.func_180501_a(posi, AllBlocks.creeplog.func_176223_P().func_177226_a((IProperty)BlockHivecreepPillar.ACTIVE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y), 3);
                HiveCreepSpreadFurther.addPoints(world);
                return;
            }
            if (block instanceof BlockGrass) {
                world.func_180501_a(posi, AllBlocks.creepedgrass.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                HiveCreepSpreadFurther.addPoints(world);
                return;
            }
            switch (HiveCreepSpreadFurther.materialMatching(HiveCreepSpreadFurther.matAtBlock(block))) {
                case 1: {
                    world.func_180501_a(posi, AllBlocks.creepedsand.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                    continue block24;
                }
                case 4: {
                    world.func_180501_a(posi, AllBlocks.creepedstone.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                    continue block24;
                }
                case 2: {
                    world.func_180501_a(posi, AllBlocks.creepeddirt.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                    continue block24;
                }
                case 3: {
                    world.func_180501_a(posi, AllBlocks.creepedgrass.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                }
            }
        }
        HiveCreepSpreadFurther.decay(pos, world, decayInto);
    }

    public static Block blockAtPos(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static IBlockState blockStateAtPos(BlockPos pos, World world) {
        return world.func_180495_p(pos);
    }

    public static Material matFromBlock(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_185904_a();
    }

    public static Material matFromBlock(Block b) {
        return b.func_176194_O().func_177621_b().func_185904_a();
    }

    public static Material matFromBlock(IBlockState b) {
        return b.func_185904_a();
    }

    public static String getBlockModName(IBlockState b) {
        return Objects.requireNonNull(b.func_177230_c().getRegistryName()).func_110624_b();
    }

    public static String getBlockModName(BlockPos pos, World world) {
        return Objects.requireNonNull(world.func_180495_p(pos).func_177230_c().getRegistryName()).func_110624_b();
    }

    public static Material matAtBlock(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_185904_a();
    }

    public static Material matAtBlock(IBlockState b) {
        return b.func_185904_a();
    }

    public static byte materialMatching(Material m) {
        if (m == Material.field_151595_p) {
            return 1;
        }
        if (m == Material.field_151578_c) {
            return 2;
        }
        if (m == Material.field_151577_b) {
            return 3;
        }
        if (m == Material.field_151576_e) {
            return 4;
        }
        if (m == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public static boolean matLookingBlock(BlockPos pos, Material mat, World world) {
        return BlockUtils.getLookingBlockMat((BlockPos)pos, (World)world) == mat;
    }
}

