/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.invasion;

import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionEvents;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class InvasionEvent {
    private int level = 1;
    private int stages;
    private int currentStage;
    private int prevStage;
    private int updateTimer;
    private int updateFreq = 0;
    private int ambienceFreq = 200;
    private boolean hasUpdated = false;
    private boolean active = false;
    private boolean requiresInvasionStart = true;

    public int getID() {
        return 0;
    }

    public int getPriority() {
        return 0;
    }

    public boolean nightOnly() {
        return false;
    }

    public void setRequiresInvasionStart(boolean requiresInvasionStart) {
        this.requiresInvasionStart = requiresInvasionStart;
    }

    public void setAmbienceFreq(int ambienceFreq) {
        this.ambienceFreq = ambienceFreq;
    }

    public int getAmbienceFreq() {
        return this.ambienceFreq;
    }

    public void resetEvent() {
        this.setInactiveState();
        this.updateTimer = 0;
        this.prevStage = 0;
        this.setCurrentStage(0);
        WyrmsOfNyrus.logger.debug("Event ID " + this.getID() + " was reset.");
    }

    public void startEvent(BlockPos position, World world) {
        this.resetEvent();
        this.setActiveState();
        WoNVars.worldVariables.get(world).updateQueue(world, this.getEventFormat());
        WyrmsOfNyrus.logger.debug("Event ID " + this.getID() + " was started.");
        this.invasionRuntime(position, world);
    }

    public String getEventFormat() {
        boolean active = this.getActiveStatus();
        return this.getID() + "," + this.getLevel() + "," + this.getStages() + "," + this.getCurrentStage() + "," + this.prevStage + "," + this.getUpdateFreq();
    }

    public void buildFromEventFormat(String formattedString) {
        String[] sList = formattedString.split(",");
        ArrayList<Integer> iList = new ArrayList<Integer>();
        for (String s : sList) {
            iList.add(Integer.parseInt(s));
        }
        if (((Integer)iList.get(0)).intValue() == this.getID()) {
            this.setLevel((Integer)iList.get(1));
            this.setStages((Integer)iList.get(2));
            this.setCurrentStage((Integer)iList.get(3));
            this.prevStage = (Integer)iList.get(4);
            this.setUpdateFreq((Integer)iList.get(5));
            this.setActiveState();
        } else {
            WyrmsOfNyrus.logger.error("Failed to read an event in the queue: " + formattedString + " likely due to a malformed string.");
        }
    }

    public boolean getActiveStatus() {
        return this.active;
    }

    public void setActiveState() {
        this.active = true;
    }

    public void setInactiveState() {
        this.active = false;
    }

    public int getStageUpdateFreq() {
        if (this.getUpdateFreq() != 0) {
            return this.getUpdateFreq() * 20;
        }
        return 1000;
    }

    public int getUpdateFreq() {
        return this.updateFreq;
    }

    public void setUpdateFreq(int updateFreq) {
        this.updateFreq = updateFreq;
    }

    private void stageCheckerUpdate(World world) {
        if (this.getCurrentStage() >= this.prevStage) {
            this.prevStage = this.getCurrentStage();
            this.setCurrentStage(this.getCurrentStage() + 1);
            this.setHasUpdated(true);
            WoNVars.worldVariables.get(world).updateQueue(world, this.getEventFormat());
            WyrmsOfNyrus.logger.debug("Ongoing event ticked");
        }
        this.updateTimer = 0;
        WyrmsOfNyrus.logger.debug(this.getCurrentStage() + " / " + this.getStages() + " stages");
    }

    private void stageTimerUpdate(World world) {
        ++this.updateTimer;
        if (this.updateTimer > this.getStageUpdateFreq()) {
            this.stageCheckerUpdate(world);
        }
    }

    public int getUpdateTimer() {
        return this.updateTimer;
    }

    public void setUpdateTimer(int updateTimer) {
        this.updateTimer = updateTimer;
    }

    public void setHasUpdated(Boolean hasUpdated) {
        this.hasUpdated = hasUpdated;
    }

    public Boolean getHasUpdated() {
        return this.hasUpdated;
    }

    public int getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(int currentStage) {
        this.currentStage = currentStage;
    }

    public void setStages(int stages) {
        this.stages = stages;
    }

    public int getStages() {
        return this.stages;
    }

    public void setLevel(int level) {
        this.level = level == 0 ? 1 : level;
    }

    public int getLevel() {
        return this.level;
    }

    public void eventStart(BlockPos position, World world) {
    }

    public void eventMidPoints(BlockPos position, World world, int part) {
    }

    public void eventEnd(BlockPos position, World world) {
        this.resetEvent();
        WoNVars.worldVariables.get(world).removeEventFromQueue(world, this.getEventFormat());
        InvasionEvents.removeExpiredEvents(world);
    }

    public void invasionRuntime(BlockPos position, World world) {
        if (this.requiresInvasionStart && !WoNVars.worldVariables.get((World)world).invasionStarted) {
            this.eventEnd(position, world);
        }
        if (this.nightOnly() && world.func_72935_r()) {
            return;
        }
        if (this.getActiveStatus()) {
            if (this.getHasUpdated().booleanValue()) {
                WyrmsOfNyrus.logger.debug("Ongoing event is running a stage event");
                if (this.getCurrentStage() <= 1) {
                    this.eventStart(position, world);
                } else if (this.getCurrentStage() >= this.getStages()) {
                    this.eventEnd(position, world);
                } else {
                    this.eventMidPoints(position, world, this.getCurrentStage());
                }
                this.setHasUpdated(false);
            }
            if (world.func_82737_E() % (long)this.getAmbienceFreq() == 0L) {
                this.ambientEffects(world);
            }
            this.stageTimerUpdate(world);
        } else {
            WyrmsOfNyrus.logger.warn("Inactive invasion event was called to tick, this shouldn't happen! Attempting to terminate forcefully, but safely.");
            this.resetEvent();
        }
    }

    public void ambientEffects(World world) {
    }
}

