/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.invasion.events;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionEvent;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EventFlashstorm
extends InvasionEvent {
    @Override
    public int getPriority() {
        return 5 * this.getLevel();
    }

    @Override
    public int getID() {
        return 7;
    }

    @Override
    public void eventStart(BlockPos position, World world) {
        this.eventSteps(world, position);
        WyrmsOfNyrus.logger.debug("Initiating Flashstorm event!");
    }

    @Override
    public void eventMidPoints(BlockPos position, World world, int part) {
        this.eventSteps(world, position);
        WyrmsOfNyrus.logger.debug("Flashstorm event ticked");
    }

    private void eventSteps(World world, BlockPos pos) {
        for (Entity ent : world.field_72996_f) {
            if (!(ent instanceof EntityWyrm) || RNG.getIntRangeInclu((int)0, (int)40) > this.getLevel() + 1) continue;
            EntityWyrm wyrm = (EntityWyrm)ent;
            double x = wyrm.field_70165_t;
            double y = wyrm.field_70163_u;
            double z = wyrm.field_70161_v;
            int[] vars = wyrm.getLegalVariants();
            ArrayList<Integer> variants = new ArrayList<Integer>();
            for (int var : vars) {
                variants.add(var);
            }
            if (variants.contains(21)) {
                wyrm.setVariant(21);
                wyrm.duplicateThisEntity();
                wyrm.func_70106_y();
                world.func_72942_c((Entity)new EntityLightningBolt(world, x, y, z, false));
                continue;
            }
            wyrm.func_70106_y();
            world.func_72942_c((Entity)new EntityLightningBolt(world, x, y, z, false));
            world.func_72876_a(null, x, y, z, (float)wyrm.getPotency() * 2.0f, false);
        }
    }

    @Override
    public void ambientEffects(World world) {
        EntityPlayer player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
        world.func_184148_a(null, player.field_70165_t + RNG.PMRange((double)100.0), player.field_70163_u, player.field_70161_v + RNG.PMRange((double)100.0), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.3f);
    }
}

