/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.invasion.events;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityCallousPod;
import com.vetpetmon.wyrmsofnyrus.common.entity.wyrms.EntityHexePod;
import com.vetpetmon.wyrmsofnyrus.common.invasion.InvasionEvent;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EventIncursion
extends InvasionEvent {
    @Override
    public int getPriority() {
        return 5 * this.getLevel();
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public void eventStart(BlockPos position, World world) {
        this.eventSteps(world, position);
        WyrmsOfNyrus.logger.debug("Initiating an incursion event!");
    }

    @Override
    public void eventMidPoints(BlockPos position, World world, int part) {
        this.eventSteps(world, position);
        WyrmsOfNyrus.logger.debug("Incursion event ticked");
    }

    private void eventSteps(World world, BlockPos pos) {
        EntityWyrm entityToSpawn;
        int i;
        double x = pos.func_177958_n();
        double z = pos.func_177952_p();
        int raidSize = RNG.getIntRangeInclu((int)(4 + this.getLevel()), (int)(6 + this.getLevel()));
        int podID = WoNVars.worldVariables.getInvasionLevel(world) > 1 ? 5 : 2;
        double y = world.func_72800_K() + 280;
        for (i = 0; i < raidSize; ++i) {
            entityToSpawn = new EntityCallousPod(world);
            entityToSpawn.setPodType(podID, 1);
            if (world.field_72995_K) continue;
            entityToSpawn.func_70012_b(x + RNG.PMRange((double)Invasion.maxEventDistance), y, z + RNG.PMRange((double)Invasion.maxEventDistance), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityToSpawn);
        }
        for (i = 0; i < raidSize; i += 2) {
            entityToSpawn = new EntityHexePod(world);
            if (world.field_72995_K) continue;
            entityToSpawn.func_70012_b(x + RNG.PMRange((double)Invasion.maxEventDistance), y, z + RNG.PMRange((double)Invasion.maxEventDistance), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityToSpawn);
        }
    }
}

