/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.locallib.util;

import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Vect3D {
    public double x;
    public double y;
    public double z;

    public Vect3D(Vect3D vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vect3D(double xIn, double yIn, double zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
    }

    public static Vect3D createVector(double xIn, double yIn, double zIn) {
        return new Vect3D(xIn, yIn, zIn);
    }

    public Vect3D setVector(double xIn, double yIn, double zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
        return this;
    }

    public double length() {
        return MathHelper.func_76133_a((double)(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0)));
    }

    public Vect3D normalize() {
        double norm = MathHelper.func_76133_a((double)(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0)));
        return norm < 1.0E-4 ? Vect3D.createVector(0.0, 0.0, 0.0) : Vect3D.createVector(this.x / norm, this.y / norm, this.z / norm);
    }

    public double dot(Vect3D vectIn) {
        return this.x * vectIn.x + this.y * vectIn.y + this.z * vectIn.z;
    }

    public Vect3D inverse() {
        return new Vect3D(-this.x, -this.y, -this.z);
    }

    public String toString() {
        return "xyz(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vector3d convertToBuiltIn3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vec3d convertToMC3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public Vector3f convertToBuiltIn3f() {
        return new Vector3f(this.convertToBuiltIn3d());
    }
}

