/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus;

import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionEvent;
import com.vetpetmon.wyrmsofnyrus.locallib.OptiMath;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class WoNVars {
    public static String wyrmInvasionStatus = "";

    public static class WorldSavedDataSyncMessage
    implements IMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage() {
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.type);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data.func_189551_b(new NBTTagCompound()));
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readInt();
            this.data = this.type == 0 ? new MapVariables() : new worldVariables();
            this.data.func_76184_a(ByteBufUtils.readTag((ByteBuf)buf));
        }
    }

    public static class WorldSavedDataSyncMessageHandler
    implements IMessageHandler<WorldSavedDataSyncMessage, IMessage> {
        public IMessage onMessage(WorldSavedDataSyncMessage message, MessageContext context) {
            if (context.side == Side.SERVER) {
                context.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> this.syncData(message, context, context.getServerHandler().field_147369_b.field_70170_p));
            } else {
                Minecraft.func_71410_x().func_152344_a(() -> this.syncData(message, context, Minecraft.func_71410_x().field_71439_g.field_70170_p));
            }
            return null;
        }

        private void syncData(WorldSavedDataSyncMessage message, MessageContext context, World world) {
            if (context.side == Side.SERVER) {
                message.data.func_76185_a();
                if (message.type == 0) {
                    WyrmsOfNyrus.PACKET_HANDLER.sendToAll((IMessage)message);
                } else {
                    WyrmsOfNyrus.PACKET_HANDLER.sendToDimension((IMessage)message, world.field_73011_w.getDimension());
                }
            }
            if (message.type == 0) {
                world.func_175693_T().func_75745_a("wyrmsofnyrus_mapvars", message.data);
            } else {
                world.getPerWorldStorage().func_75745_a("wyrmsofnyrus_worldvars", message.data);
            }
        }
    }

    public static class worldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "wyrmsofnyrus_worldvars";
        public double wyrmInvasionPoints = 0.0;
        public double wyrmInvasionDifficulty = 1.0;
        public String distressCode = "_.._.";
        public String eventQueueSlot1 = "empty";
        public String eventQueueSlot2 = "empty";
        public String eventQueueSlot3 = "empty";
        public String eventQueueSlot4 = "empty";
        public String eventQueueSlot5 = "empty";
        public int wyrmsKilledToday = 0;
        public int wyrmResources = 0;
        public int invasionLevel = 0;
        public int eventSchedulerCurrentInstance = 0;
        public int eventSchedulerNextInstance = 0;
        public int pastDistressCall = 0;
        public int infamy = 0;
        public boolean invasionStarted = false;
        public boolean purgedWereSpawned = false;
        public ArrayList<InvasionEvent> activeEvents = new ArrayList();

        public worldVariables() {
            super(DATA_NAME);
        }

        public worldVariables(String s) {
            super(s);
        }

        public static String generateDistressCode(Random rng, String characters, int length) {
            char[] text = new char[length];
            for (int i = 0; i < length; ++i) {
                text[i] = characters.charAt(rng.nextInt(characters.length()));
            }
            return new String(text);
        }

        public ArrayList<String> getQueueFromWorld() {
            return new ArrayList<String>(Arrays.asList(this.eventQueueSlot1, this.eventQueueSlot2, this.eventQueueSlot3, this.eventQueueSlot4, this.eventQueueSlot5));
        }

        public void clearQueue(World w) {
            this.eventQueueSlot1 = "empty";
            this.eventQueueSlot2 = "empty";
            this.eventQueueSlot3 = "empty";
            this.eventQueueSlot4 = "empty";
            this.eventQueueSlot5 = "empty";
            worldVariables.get(w).syncData(w);
        }

        public boolean emptyQueue() {
            int emptySlots = 0;
            block7: for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 1: {
                        if (!this.eventQueueSlot1.equalsIgnoreCase("empty")) continue block7;
                        ++emptySlots;
                        continue block7;
                    }
                    case 2: {
                        if (!this.eventQueueSlot2.equalsIgnoreCase("empty")) continue block7;
                        ++emptySlots;
                        continue block7;
                    }
                    case 3: {
                        if (!this.eventQueueSlot3.equalsIgnoreCase("empty")) continue block7;
                        ++emptySlots;
                        continue block7;
                    }
                    case 4: {
                        if (!this.eventQueueSlot4.equalsIgnoreCase("empty")) continue block7;
                        ++emptySlots;
                        continue block7;
                    }
                    case 5: {
                        if (!this.eventQueueSlot5.equalsIgnoreCase("empty")) continue block7;
                        ++emptySlots;
                    }
                }
            }
            return emptySlots >= 5;
        }

        public void queueEvent(World w, int quePos, String format) {
            WyrmsOfNyrus.logger.debug(String.format("Attempting to put event [%s] in slot %d", format, quePos));
            switch (quePos) {
                case 1: {
                    if (!this.doesFormatMatch(format, this.eventQueueSlot1, true)) break;
                    this.eventQueueSlot1 = format;
                    break;
                }
                case 2: {
                    if (!this.doesFormatMatch(format, this.eventQueueSlot2, true)) break;
                    this.eventQueueSlot2 = format;
                    break;
                }
                case 3: {
                    if (!this.doesFormatMatch(format, this.eventQueueSlot3, true)) break;
                    this.eventQueueSlot3 = format;
                    break;
                }
                case 4: {
                    if (!this.doesFormatMatch(format, this.eventQueueSlot4, true)) break;
                    this.eventQueueSlot4 = format;
                    break;
                }
                case 5: {
                    if (!this.doesFormatMatch(format, this.eventQueueSlot5, true)) break;
                    this.eventQueueSlot5 = format;
                }
            }
            worldVariables.get(w).syncData(w);
        }

        public void queueEventOveride(World w, int quePos, String format) {
            WyrmsOfNyrus.logger.debug(String.format("Attempting to override event [%s] in slot %d", format, quePos));
            switch (quePos) {
                case 1: {
                    this.eventQueueSlot1 = format;
                    break;
                }
                case 2: {
                    this.eventQueueSlot2 = format;
                    break;
                }
                case 3: {
                    this.eventQueueSlot3 = format;
                    break;
                }
                case 4: {
                    this.eventQueueSlot4 = format;
                    break;
                }
                case 5: {
                    this.eventQueueSlot5 = format;
                }
            }
            worldVariables.get(w).syncData(w);
        }

        public boolean doesFormatMatch(String formattedString, String formatInFile, boolean strict) {
            if (formatInFile.equalsIgnoreCase("empty")) {
                return !strict;
            }
            String[] sList = formattedString.split(",");
            String[] sFList = formatInFile.split(",");
            ArrayList<Integer> iList = new ArrayList<Integer>();
            ArrayList<Integer> iFList = new ArrayList<Integer>();
            for (String s : sList) {
                iList.add(Integer.parseInt(s));
            }
            for (String s : sFList) {
                iFList.add(Integer.parseInt(s));
            }
            for (int i = 0; i < iList.size(); ++i) {
                if (i == 4 || i == 3 || Objects.equals(iList.get(i), iFList.get(i))) continue;
                return false;
            }
            return true;
        }

        public void updateQueue(World w, String format) {
            WyrmsOfNyrus.logger.debug(String.format("Attempting to update event [%s]", format));
            if (this.doesFormatMatch(format, this.eventQueueSlot1, false)) {
                this.eventQueueSlot1 = format;
            } else if (this.doesFormatMatch(format, this.eventQueueSlot2, false)) {
                this.eventQueueSlot2 = format;
            } else if (this.doesFormatMatch(format, this.eventQueueSlot3, false)) {
                this.eventQueueSlot3 = format;
            } else if (this.doesFormatMatch(format, this.eventQueueSlot4, false)) {
                this.eventQueueSlot4 = format;
            } else if (this.doesFormatMatch(format, this.eventQueueSlot5, false)) {
                this.eventQueueSlot5 = format;
            }
            worldVariables.get(w).syncData(w);
        }

        public void removeEventFromQueue(World w, String format) {
            WyrmsOfNyrus.logger.debug(String.format("Removing event [%s] from queue", format));
            if (this.doesFormatMatch(format, this.eventQueueSlot1, false)) {
                this.eventQueueSlot1 = "empty";
            } else if (this.doesFormatMatch(format, this.eventQueueSlot2, false)) {
                this.eventQueueSlot2 = "empty";
            } else if (this.doesFormatMatch(format, this.eventQueueSlot3, false)) {
                this.eventQueueSlot3 = "empty";
            } else if (this.doesFormatMatch(format, this.eventQueueSlot4, false)) {
                this.eventQueueSlot4 = "empty";
            } else if (this.doesFormatMatch(format, this.eventQueueSlot5, false)) {
                this.eventQueueSlot5 = "empty";
            }
            worldVariables.get(w).syncData(w);
        }

        public int getClearQueueSlot() {
            if (this.eventQueueSlot1.equalsIgnoreCase("empty")) {
                return 1;
            }
            if (this.eventQueueSlot2.equalsIgnoreCase("empty")) {
                return 2;
            }
            if (this.eventQueueSlot3.equalsIgnoreCase("empty")) {
                return 3;
            }
            if (this.eventQueueSlot4.equalsIgnoreCase("empty")) {
                return 4;
            }
            if (this.eventQueueSlot5.equalsIgnoreCase("empty")) {
                return 5;
            }
            return 0;
        }

        private void getQueueFromNBT(NBTTagCompound nbt) {
            this.eventQueueSlot1 = nbt.func_74779_i("queue1");
            this.eventQueueSlot2 = nbt.func_74779_i("queue2");
            this.eventQueueSlot3 = nbt.func_74779_i("queue3");
            this.eventQueueSlot4 = nbt.func_74779_i("queue4");
            this.eventQueueSlot5 = nbt.func_74779_i("queue5");
        }

        private void setQueueToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("queue1", this.eventQueueSlot1);
            nbt.func_74778_a("queue2", this.eventQueueSlot2);
            nbt.func_74778_a("queue3", this.eventQueueSlot3);
            nbt.func_74778_a("queue4", this.eventQueueSlot4);
            nbt.func_74778_a("queue5", this.eventQueueSlot5);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.wyrmInvasionPoints = OptiMath.arcForm(nbt.func_74769_h("wyrmInvasionPoints"));
            this.wyrmInvasionDifficulty = nbt.func_74769_h("wyrmInvasionDifficulty");
            this.invasionStarted = nbt.func_74767_n("invasionStarted");
            this.eventSchedulerCurrentInstance = nbt.func_74762_e("eventCurrentInst");
            this.eventSchedulerNextInstance = nbt.func_74762_e("eventNextInst");
            this.distressCode = nbt.func_74779_i("distressCode");
            this.pastDistressCall = nbt.func_74762_e("pastDistressCall");
            this.infamy = nbt.func_74762_e("infamy");
            this.wyrmResources = nbt.func_74762_e("resources");
            this.invasionLevel = nbt.func_74762_e("invasionLevel");
            this.wyrmsKilledToday = nbt.func_74762_e("wyrmsKilledToday");
            this.purgedWereSpawned = nbt.func_74767_n("purgedWereSpawned");
            this.getQueueFromNBT(nbt);
        }

        public static int getInvasionLevel(World w) {
            return worldVariables.get((World)w).invasionLevel;
        }

        public static void setInvasionLevel(World w, int value) {
            worldVariables.get((World)w).invasionLevel = value;
            worldVariables.get(w).syncData(w);
        }

        public static boolean getSpawnPurged(World w) {
            return worldVariables.get((World)w).purgedWereSpawned;
        }

        public static void toggleSpawnPurged(World w) {
            worldVariables.get((World)w).purgedWereSpawned ^= true;
            worldVariables.get(w).syncData(w);
        }

        public static int getWyrmsKilled(World w) {
            return worldVariables.get((World)w).wyrmsKilledToday;
        }

        public static void addWyrmsKilled(World w) {
            ++worldVariables.get((World)w).wyrmsKilledToday;
            worldVariables.get(w).syncData(w);
        }

        public static void resetWyrmsKilled(World w) {
            worldVariables.get((World)w).wyrmsKilledToday = 0;
            worldVariables.get(w).syncData(w);
        }

        @Nonnull
        public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
            nbt.func_74768_a("infamy", this.infamy);
            nbt.func_74768_a("eventCurrentInst", this.eventSchedulerCurrentInstance);
            nbt.func_74768_a("invasionLevel", this.invasionLevel);
            nbt.func_74768_a("eventNextInst", this.eventSchedulerNextInstance);
            nbt.func_74768_a("pastDistressCall", this.pastDistressCall);
            nbt.func_74757_a("invasionStarted", this.invasionStarted);
            nbt.func_74780_a("wyrmInvasionPoints", this.wyrmInvasionPoints);
            nbt.func_74780_a("wyrmInvasionDifficulty", OptiMath.arcForm(this.wyrmInvasionDifficulty));
            nbt.func_74778_a("distressCode", this.distressCode);
            nbt.func_74768_a("resources", this.wyrmResources);
            nbt.func_74768_a("wyrmsKilledToday", this.wyrmsKilledToday);
            nbt.func_74757_a("purgedWereSpawned", this.purgedWereSpawned);
            if (this.distressCode.length() < 20) {
                nbt.func_74778_a("distressCode", worldVariables.generateDistressCode(new Random(), "_...", 20));
            }
            this.setQueueToNBT(nbt);
            return nbt;
        }

        public void syncData(World world) {
            this.func_76185_a();
            if (world.field_72995_K) {
                WyrmsOfNyrus.PACKET_HANDLER.sendToServer((IMessage)new WorldSavedDataSyncMessage(1, this));
            } else {
                WyrmsOfNyrus.PACKET_HANDLER.sendToDimension((IMessage)new WorldSavedDataSyncMessage(1, this), world.field_73011_w.getDimension());
            }
        }

        public static worldVariables get(World world) {
            worldVariables instance = (worldVariables)world.getPerWorldStorage().func_75742_a(worldVariables.class, DATA_NAME);
            if (instance == null) {
                instance = new worldVariables();
                world.getPerWorldStorage().func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "wyrmsofnyrus_mapvars";

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound nbt) {
        }

        public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
            return nbt;
        }

        public void syncData(World world) {
            this.func_76185_a();
            if (world.field_72995_K) {
                WyrmsOfNyrus.PACKET_HANDLER.sendToServer((IMessage)new WorldSavedDataSyncMessage(0, this));
            } else {
                WyrmsOfNyrus.PACKET_HANDLER.sendToAll((IMessage)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(World world) {
            MapVariables instance = (MapVariables)world.func_175693_T().func_75742_a(MapVariables.class, DATA_NAME);
            if (instance == null) {
                instance = new MapVariables();
                world.func_175693_T().func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
    }
}

