/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus;

import com.vetpetmon.synlib.client.rendering.IHasModel;
import com.vetpetmon.wyrmsofnyrus.Constants;
import com.vetpetmon.wyrmsofnyrus.IProxyWyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.advancements.Advancements;
import com.vetpetmon.wyrmsofnyrus.block.AllBlocks;
import com.vetpetmon.wyrmsofnyrus.capabilities.ARSCapability;
import com.vetpetmon.wyrmsofnyrus.capabilities.ARSDataStore;
import com.vetpetmon.wyrmsofnyrus.capabilities.IARSCapability;
import com.vetpetmon.wyrmsofnyrus.client.ClientHandler;
import com.vetpetmon.wyrmsofnyrus.client.RenderEngine;
import com.vetpetmon.wyrmsofnyrus.command.CommandWyrmGestaltCommand;
import com.vetpetmon.wyrmsofnyrus.command.CommandWyrmInvasionCommand;
import com.vetpetmon.wyrmsofnyrus.command.CommandWyrmsTest;
import com.vetpetmon.wyrmsofnyrus.compat.HBM;
import com.vetpetmon.wyrmsofnyrus.compat.SRP;
import com.vetpetmon.wyrmsofnyrus.compat.SRR;
import com.vetpetmon.wyrmsofnyrus.config.ConfigBase;
import com.vetpetmon.wyrmsofnyrus.creativetab.TabWyrms;
import com.vetpetmon.wyrmsofnyrus.entity.WyrmRegister;
import com.vetpetmon.wyrmsofnyrus.entity.variant.WyrmVariant;
import com.vetpetmon.wyrmsofnyrus.handlers.OreDictHandler;
import com.vetpetmon.wyrmsofnyrus.handlers.WoNRecipeHandler;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionEvents;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionScheduler;
import com.vetpetmon.wyrmsofnyrus.item.AllItems;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="wyrmsofnyrus", name="Wyrms of Nyrus", version="0.7.83", dependencies="required-after:synlib@[4.0,)")
public class WyrmsOfNyrus {
    public static final String MODID = "wyrmsofnyrus";
    public static final String NAME = "Wyrms of Nyrus";
    public static final String VERSION = "0.7.83";
    public static final String OFFICIAL_DISTRO = "https://modrinth.com/mod/wyrms";
    public static CreativeTabs wyrmTabs = new TabWyrms(CreativeTabs.getNextID(), "wyrms");
    public static SimpleNetworkWrapper PACKET_HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("wyrmsofnyrus:a");
    @SidedProxy(clientSide="com.vetpetmon.wyrmsofnyrus.ClientProxyWyrmsOfNyrus", serverSide="com.vetpetmon.wyrmsofnyrus.ServerProxyWyrmsOfNyrus")
    public static IProxyWyrmsOfNyrus proxy;
    @Mod.Instance(value="wyrmsofnyrus")
    public static WyrmsOfNyrus instance;
    public static Logger logger;
    private int messageID = 0;

    public static boolean isLinuxOS() {
        return SystemUtils.IS_OS_LINUX;
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        logger.info("[NAT SELECT] Loading genome data from world");
        for (WyrmVariant v : Constants.variantObjs) {
            if (new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b().getPath() + "/genomes/genome_" + v.getID() + ".genesis").exists()) {
                v.loadMutationFile((World)DimensionManager.getWorld((int)0));
                continue;
            }
            logger.error("[NAT SELECT] You've updated WoN and this world hasn't yet regenerated, we'll fix that in a quick moment!");
            new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b().getPath() + "/genomes").mkdir();
            v.createMutationFile((World)DimensionManager.getWorld((int)0));
            v.loadMutationFile((World)DimensionManager.getWorld((int)0));
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        logger.info("[NAT SELECT] saving genome data to world");
        for (WyrmVariant v : Constants.variantObjs) {
            if (new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b().getPath() + "/genomes/genome_" + v.getID() + ".genesis").exists()) {
                v.createMutationFile((World)DimensionManager.getWorld((int)0));
                continue;
            }
            new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b().getPath() + "/genomes").mkdir();
            v.createMutationFile((World)DimensionManager.getWorld((int)0));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (logger == null) {
            logger = event.getModLog();
        }
        ConfigBase.setConfigPreset();
        ConfigBase.checkFactorySettings();
        ConfigBase.activatePreset();
        HBM.compatInit();
        SRP.compatInit();
        SRR.compatInit();
        CapabilityManager.INSTANCE.register(IARSCapability.class, (Capability.IStorage)new ARSDataStore(), ARSCapability.FACTORY);
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit(event);
        this.addNetworkMessage(WoNVars.WorldSavedDataSyncMessageHandler.class, WoNVars.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            WoNVars.MapVariables mapdata = WoNVars.MapVariables.get(event.player.field_70170_p);
            WoNVars.worldVariables worlddata = WoNVars.worldVariables.get(event.player.field_70170_p);
            PACKET_HANDLER.sendTo((IMessage)new WoNVars.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            PACKET_HANDLER.sendTo((IMessage)new WoNVars.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            WoNVars.worldVariables worlddata = WoNVars.worldVariables.get(event.player.field_70170_p);
            PACKET_HANDLER.sendTo((IMessage)new WoNVars.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
        WoNVars.worldVariables.get((World)event.player.func_130014_f_()).activeEvents.clear();
        InvasionEvents.readEventQueue(event.player.func_130014_f_());
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        SoundRegistry.RegisterSounds();
        WoNRecipeHandler.register();
        WyrmRegister.register();
        OreDictHandler.registerOres();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void BlockColorHandlerInit(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{AllBlocks.creepedgrass});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void ItemColorHandlerInit(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), new Block[]{AllBlocks.creepedgrass});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        if (SRP.isEnabled()) {
            SRP.compatPostInt();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        proxy.serverLoad(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWyrmInvasionCommand());
        event.registerServerCommand((ICommand)new CommandWyrmsTest());
        event.registerServerCommand((ICommand)new CommandWyrmGestaltCommand());
        InvasionScheduler.getScheduler(event.getServer().func_130014_f_());
        Advancements.init(event.getServer());
        WoNVars.worldVariables.get((World)event.getServer().func_130014_f_()).activeEvents.clear();
        InvasionEvents.readEventQueue(event.getServer().func_130014_f_());
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MODID, name);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ClientHandler.RegisterCustomMeshStates();
        for (Item item : AllItems.ALL_ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : AllBlocks.ALL_BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        AllBlocks.initFluids();
        event.getRegistry().registerAll((IForgeRegistryEntry[])AllBlocks.ALL_BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])AllItems.ALL_ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ClientHandler.RegisterCustomMeshStates();
        for (Item item : AllItems.ALL_ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : AllBlocks.ALL_BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void registerRenderers(FMLPreInitializationEvent event) {
        RenderEngine.renderEngine();
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

