/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.block.generic;

import com.vetpetmon.synlib.client.rendering.IHasModel;
import com.vetpetmon.synlib.core.util.SynMath;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.block.AllBlocks;
import com.vetpetmon.wyrmsofnyrus.item.AllItems;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends Block
implements IHasModel {
    private boolean hastooltip = false;
    private boolean cantStopSpawns = true;
    private boolean leavesRendering = false;
    private boolean dropsNothing = false;
    private boolean dropsShards = false;
    private BlockRenderLayer rendering;
    private Item droppedItem;

    public BlockBase(Material m, String s, SoundType st, float hardness, float blastresist, boolean hastooltip, BlockRenderLayer renderType, String effectiveTool, int toolLevel, int lightOpacity, float lightLevel) {
        super(m);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149672_a(st);
        this.func_149711_c(hardness);
        this.func_149752_b(blastresist);
        this.setRendering(renderType);
        this.hastooltip = hastooltip;
        this.setHarvestLevel(effectiveTool, toolLevel);
        this.func_149715_a(lightLevel);
        this.func_149713_g(lightOpacity);
        this.func_149647_a(WyrmsOfNyrus.wyrmTabs);
        AllBlocks.ALL_BLOCKS.add(this);
        AllItems.ALL_ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(Objects.requireNonNull(this.getRegistryName())));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.getRendering();
    }

    public void setRendering(BlockRenderLayer rt) {
        this.rendering = rt;
    }

    public BlockRenderLayer getRendering() {
        return this.rendering;
    }

    public Block setCanCreatureSpawn(boolean flag) {
        this.cantStopSpawns = flag;
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.cantStopSpawns;
    }

    public Block setToolStats(String effectiveTool, int toolLevel) {
        this.setHarvestLevel(effectiveTool, toolLevel);
        return this;
    }

    public void registerModels() {
        WyrmsOfNyrus.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.hastooltip) {
            tooltip.add(I18n.func_135052_a((String)("tooltip.won." + this.func_149739_a()), (Object[])new Object[0]));
        }
    }

    public BlockBase renderLikeLeaves() {
        this.leavesRendering = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.leavesRendering) {
            return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c().getRegistryName() != this.getRegistryName() && super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.leavesRendering;
    }

    public BlockBase dropNothing() {
        this.dropsNothing = true;
        return this;
    }

    public boolean willDropShards() {
        return this.dropsShards;
    }

    public Item droppedItem() {
        return this.droppedItem;
    }

    public BlockBase dropShards(Item shards) {
        this.dropsShards = true;
        this.droppedItem = shards;
        return this;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!this.dropsNothing) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.dropsShards) {
            return this.droppedItem;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(Random random) {
        if (this.dropsShards) {
            return SynMath.clampInt((int)(-3 + random.nextInt(5)), (int)0, (int)1);
        }
        return 1;
    }

    public int func_149679_a(int fortune, Random random) {
        if (this.dropsShards) {
            return MathHelper.func_76125_a((int)(this.func_149745_a(random) + random.nextInt(fortune + 1)), (int)0, (int)2);
        }
        return this.func_149745_a(random);
    }
}

