/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.capabilities;

import com.vetpetmon.wyrmsofnyrus.capabilities.IARSCapability;
import com.vetpetmon.wyrmsofnyrus.config.PlayerConfig;
import com.vetpetmon.wyrmsofnyrus.handlers.WoNDamageSources;
import java.util.concurrent.Callable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ARSCapability
implements IARSCapability {
    public static final Callable<IARSCapability> FACTORY = ARSCapability::new;
    private float grays = 0.0f;
    private int ARSStage = 0;
    private int ARSStacks = 0;
    private int timerTicks = 0;
    private int timerSeconds = 0;

    @Override
    public float getGrays() {
        return this.grays;
    }

    @Override
    public int getTimerTicks() {
        return this.timerTicks;
    }

    @Override
    public void setTimerTicks(int timerTicks) {
        this.timerTicks = timerTicks;
    }

    @Override
    public int getTimerSeconds() {
        return this.timerSeconds;
    }

    @Override
    public void setTimerSeconds(int timerSeconds) {
        this.timerSeconds = timerSeconds;
    }

    public void updateTimer() {
        ++this.timerTicks;
        if (this.getTimerTicks() >= 20) {
            ++this.timerSeconds;
            this.timerTicks = 0;
        }
    }

    @Override
    public int getARSStacks() {
        return this.ARSStacks;
    }

    @Override
    public void setARSStacks(int stackVal) {
        this.ARSStacks = Math.max(0, stackVal);
    }

    @Override
    public void addARSStacks(int stackVal) {
        this.setARSStacks(this.ARSStacks + stackVal);
    }

    @Override
    public void removeARSStacks(int stackVal) {
        this.setARSStacks(this.ARSStacks - stackVal);
    }

    @Override
    public void setGrays(float Gy) {
        this.grays = Math.max(0.0f, Gy);
    }

    @Override
    public void addGrays(float Gy) {
        this.setGrays(this.grays + Gy);
    }

    @Override
    public void removeGrays(float Gy) {
        this.setGrays(this.grays - Gy);
    }

    @Override
    public void saveNBTData(NBTTagCompound tag) {
        tag.func_74776_a("grays", this.getGrays());
        tag.func_74768_a("stacks", this.getARSStacks());
        tag.func_74768_a("stage", this.getARSStage());
        tag.func_74768_a("ticktimer", this.getTimerTicks());
        tag.func_74768_a("secondstimer", this.getTimerSeconds());
    }

    @Override
    public void loadNBTData(NBTTagCompound tag) {
        this.setGrays(tag.func_74760_g("grays"));
        this.setARSStacks(tag.func_74762_e("stacks"));
        this.setARSStage(tag.func_74762_e("stage"));
        this.setTimerTicks(tag.func_74762_e("ticktimer"));
        this.setTimerSeconds(tag.func_74762_e("secondstimer"));
    }

    @Override
    public void tickUpdate(EntityPlayer player, World world, TickEvent.Phase phase) {
        float Gy = this.getGrays();
        this.updateTimer();
        if (this.getTimerSeconds() >= PlayerConfig.secondsPerDose) {
            this.setTimerSeconds(0);
            if (PlayerConfig.upperSafeThreshold < Gy && PlayerConfig.upperMildThreshold >= Gy) {
                this.handleStacks(1);
            } else if (PlayerConfig.upperModerateThreshold >= Gy) {
                this.handleStacks(2);
            } else if (PlayerConfig.upperSevereThreshold >= Gy) {
                this.handleStacks(3);
            } else if (PlayerConfig.upperDeadlyThreshold >= Gy) {
                this.handleStacks(4);
            }
            this.setGrays(0.0f);
        }
        if (this.getARSStage() >= 3 && player.func_70051_ag()) {
            player.func_70031_b(false);
        }
        if (Gy > PlayerConfig.upperDeadlyThreshold && !player.field_70128_L) {
            player.func_70097_a(WoNDamageSources.ARS, 5000000.0f);
            player.func_70606_j(0.0f);
            player.func_70645_a(WoNDamageSources.ARS);
        }
    }

    public void handleStacks(int StackBuffer) {
        if (this.getARSStage() > 0) {
            this.addARSStacks(StackBuffer);
        } else if (this.getARSStage() < StackBuffer) {
            this.setARSStage(StackBuffer);
        }
    }

    @Override
    public void setARSStage(int stage) {
        this.ARSStage = stage;
    }

    @Override
    public int getARSStage() {
        return this.ARSStage;
    }
}

