/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.config;

import com.vetpetmon.synlib.core.util.CFG;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.config.Addons;
import com.vetpetmon.wyrmsofnyrus.config.Client;
import com.vetpetmon.wyrmsofnyrus.config.ConfigManifest;
import com.vetpetmon.wyrmsofnyrus.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.config.Modifiers;
import com.vetpetmon.wyrmsofnyrus.config.PlayerConfig;
import com.vetpetmon.wyrmsofnyrus.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.config.WorldConfig;
import com.vetpetmon.wyrmsofnyrus.config.WyrmStats;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.minecraftforge.common.config.Configuration;

public class ConfigBase {
    private static final int defaultConfig = 0;
    private static final String[] factoryConfigs = new String[]{"Arcade", "Classic", "Dark Forest"};
    public static int selectedPreset;
    public static int presetsVersion;
    private static String ConfigDirectory;
    private static Configuration general;
    private static Configuration wyrms;
    private static Configuration world;
    private static Configuration invasion;
    private static Configuration addons;
    private static Configuration manifest;
    private static Configuration player;
    private static Configuration modifiers;
    public static boolean newBoot;

    public static void setConfigPreset() {
        selectedPreset = Client.configPreset;
        if (Client.configPreset < 0) {
            selectedPreset = 0;
        }
        if (selectedPreset > 3) {
            WyrmsOfNyrus.logger.info("Using or creating user-defined config preset folder, configs are in folder: " + selectedPreset);
            ConfigBase.customConfigGen();
        } else {
            WyrmsOfNyrus.logger.info("Using factory preset: " + selectedPreset);
        }
    }

    public static int presetInts(int normal, int classic, int darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static int[] presetIntArrays(int[] normal, int[] classic, int[] darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static float presetFloats(float normal, float classic, float darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static float[] presetFloatArrays(float[] normal, float[] classic, float[] darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static boolean presetBools(boolean normal, boolean classic, boolean darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static String presetStrings(String normal, String classic, String darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static String[] presetStringArrays(String[] normal, String[] classic, String[] darkForest, int id) {
        switch (id) {
            case 1: {
                return classic;
            }
            case 2: {
                return darkForest;
            }
        }
        return normal;
    }

    public static void activatePreset() {
        WyrmsOfNyrus.logger.info("Active preset: " + selectedPreset);
        ConfigBase.createDirectories(selectedPreset);
        ConfigBase.reloadConfig(selectedPreset);
    }

    public static void reloadConfig(int id) {
        Configuration[] configs;
        for (Configuration i : configs = new Configuration[]{general, wyrms, world, invasion, addons, manifest, player, modifiers}) {
            i.load();
        }
        ConfigManifest.createManifest(manifest);
        AI.loadFromConfig(general, id);
        Radiogenetics.loadFromConfig(general, id);
        WyrmStats.loadFromConfig(wyrms, id);
        WorldConfig.loadFromConfig(world, id);
        Invasion.loadFromConfig(invasion, id);
        Addons.loadFromConfig(addons, id);
        PlayerConfig.loadFromConfig(player, id);
        Modifiers.loadFromConfig(modifiers, id);
        for (Configuration i : configs) {
            i.save();
        }
    }

    public static void firstTimeDialogue() {
        JFrame jf = new JFrame();
        final JDialog jd = new JDialog(jf);
        jf.setTitle("Wyrms of Nyrus");
        jd.setLayout(new FlowLayout());
        jd.setBounds(600, 500, 800, 175);
        JLabel jl = new JLabel("This appears to be your first time with Wyrms of Nyrus, or you have missing/outdated factory configurations.");
        JLabel jl2 = new JLabel("You can safely disregard this message. If you wish to change the preset, there is an in-game option to do so.");
        JLabel jl3 = new JLabel("If your preset choice is unset or invalid, it will default back to this preset: " + factoryConfigs[0]);
        JButton norm = new JButton("Yes");
        norm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jd.setVisible(false);
            }
        });
        jd.add(jl);
        jd.add(jl2);
        jd.add(jl3);
        jf.pack();
        jd.add(norm);
        jd.setVisible(true);
    }

    public static void checkFactorySettings() {
        boolean oneConfigInvalidated = false;
        for (int i = 0; i < factoryConfigs.length; ++i) {
            WyrmsOfNyrus.logger.info("Checking factory settings for " + i);
            ConfigDirectory = WyrmsOfNyrus.proxy.getDataDir().getPath() + "/config/WyrmsOfNyrus/" + i + "/";
            if (!Files.exists(Paths.get(ConfigDirectory, new String[0]), new LinkOption[0])) {
                WyrmsOfNyrus.logger.info("Factory preset \"" + i + "\" does not exist, making it in the following directory: " + ConfigDirectory);
                oneConfigInvalidated = true;
                newBoot = true;
            }
            ConfigBase.createDirectories(i);
            ConfigBase.reloadConfig(i);
            if (!ConfigManifest.compareVersion()) continue;
            WyrmsOfNyrus.logger.warn("Factory preset \"" + i + "\" has version mismatch.");
            File folder = new File(ConfigDirectory);
            File[] files = folder.listFiles();
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
                folder.delete();
            }
            newBoot = true;
            WyrmsOfNyrus.logger.info("Attempted to delete directory and update it.");
            ConfigBase.createDirectories(i);
            ConfigBase.reloadConfig(i);
        }
        if (oneConfigInvalidated && Client.firstTimeBoot && !GraphicsEnvironment.isHeadless()) {
            WyrmsOfNyrus.logger.info("IF YOUR GAME CRASHES AT THIS POINT DUE TO \"pthread_mutex_lock+0x4\", THERE IS A WORKAROUND IN /config/Wyrms of Nyrus Client.cfg");
            WyrmsOfNyrus.logger.info("Set \"Don't Greet Me\" to false;");
            WyrmsOfNyrus.logger.info("The greeting message may break on certain Linux systems and all terminal systems!");
            WyrmsOfNyrus.logger.debug("This is a debug environment. The pop-up window may break, PLEASE test this outside of dev env");
            if (!WyrmsOfNyrus.isLinuxOS()) {
                ConfigBase.firstTimeDialogue();
            } else {
                WyrmsOfNyrus.logger.info("Wyrms of Nyrus detects you are using Linux. If you did not see the first-time dialogue, we recommend you check the configuration files for the mod. The dialogue window notifying you of the mod's configuration files being set to the default difficulty preset have been disabled to minimize issues involving Swift and XOrg desktop environments not playing nicely.");
            }
        }
    }

    public static void customConfigGen() {
        if (!Files.exists(Paths.get(WyrmsOfNyrus.proxy.getDataDir().getPath() + "/config/WyrmsOfNyrus/" + selectedPreset + "/", new String[0]), new LinkOption[0])) {
            ConfigDirectory = WyrmsOfNyrus.proxy.getDataDir().getPath() + "/config/WyrmsOfNyrus/" + selectedPreset + "/";
            WyrmsOfNyrus.logger.info("Custom preset \"" + selectedPreset + "\" does not exist, making it in the following directory: " + ConfigDirectory);
            WyrmsOfNyrus.logger.info("This is a custom preset. Once this generates, you are free to edit it as you wish.");
            ConfigBase.createDirectories(selectedPreset);
            ConfigBase.reloadConfig(selectedPreset);
        }
    }

    private static void createDirectories(int id) {
        ConfigDirectory = WyrmsOfNyrus.proxy.getDataDir().getPath() + "/config/WyrmsOfNyrus/" + id + "/";
        general = CFG.createDirectory((String)"general", (String)ConfigDirectory);
        wyrms = CFG.createDirectory((String)"wyrms", (String)ConfigDirectory);
        world = CFG.createDirectory((String)"world", (String)ConfigDirectory);
        invasion = CFG.createDirectory((String)"invasion", (String)ConfigDirectory);
        addons = CFG.createDirectory((String)"addons", (String)(ConfigDirectory + "addons/"));
        manifest = CFG.createDirectory((String)"manifest", (String)ConfigDirectory);
        player = CFG.createDirectory((String)"players", (String)ConfigDirectory);
        modifiers = CFG.createDirectory((String)"modifiers", (String)ConfigDirectory);
    }

    static {
        presetsVersion = 63;
        ConfigDirectory = WyrmsOfNyrus.proxy.getDataDir().getPath() + "/config/WyrmsOfNyrus/";
    }
}

