/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.config;

import com.vetpetmon.synlib.core.util.BlacklistUtil;
import com.vetpetmon.synlib.core.util.CFG;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.ConfigBase;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionEvents;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class Invasion {
    public static boolean invasionEnabled;
    public static boolean invasionStartsNaturally;
    public static int invasionStartMode;
    public static int invasionStartTime;
    public static int invasionStartChance;
    public static int invasionEventFrequency;
    public static boolean probingEnabled;
    public static int invasionPointsPerKill;
    public static int minWyrmsHexepod;
    public static int maxWyrmsHexepod;
    public static int minWyrmsCallouspod;
    public static int maxWyrmsCallouspod;
    public static int visitorDropPodFrequency;
    public static int visitorDropPodFrequencyVariation;
    public static int iPointsIStage1Threshold;
    public static int iPointsIStage2Threshold;
    public static int iPointsIStage3Threshold;
    public static int iPointsIStage4Threshold;
    public static int iPointsIStage5Threshold;
    public static int iPointsIStage6Threshold;
    public static int maxEventDistance;
    public static boolean creepEnabled;
    public static boolean creepBlocksProduceGas;
    public static boolean creepConversionKeepNametag;
    public static int creepSpreadRate;
    public static int creepTickRate;
    public static int normCreepwyrmCreepSpeed;
    public static int direCreepwyrmCreepSpeed;
    public static int creephiveCreepSpeed;
    public static int creepInactivityChance;
    public static float creepSpreadPoints;
    public static float creepSpreadMaxHardness;
    public static String[] creepConvertList;
    public static String[] invalidBlocksForCreepspread;
    public static String[] invasionStage0EventPool;
    public static String[] invasionStage1EventPool;
    public static String[] invasionStage2EventPool;
    public static String[] invasionStage3EventPool;
    public static String[] invasionStage4EventPool;
    public static String[] invasionStage5EventPool;
    public static String[] invasionStage6EventPool;
    public static int[] invadeableDimensions;
    private static final int[] invasiondims;
    public static boolean CSBlockBLEnabled;
    public static ArrayList<Block> invalidBlocks;
    public static String[] iBdef;
    public static String[] invstage1poolDef;
    public static String[] invstage2poolDef;
    public static String[] invstage3poolDef;
    public static String[] creepConversionDef;

    public static void loadFromConfig(Configuration config, int id) {
        String CATEGORY = "Invasion";
        config.addCustomCategoryComment("Invasion", "\nThe Wyrm Invasion is the main mechanic of this mod, with a fully-fledged event system with threats that keep players on edge.\n\n\nEvent IDS: \n\n0 - Visitor\n1 - Incursion\n2 - Scouters\n3 - Wyrmlings\n4 - Creep pods\n5 - Creepwyrm\n6 - Air raid\n7 - Flashstorm");
        config.setCategoryRequiresWorldRestart("Invasion", true);
        String CATEGORYTWO = "Hive Creep";
        config.addCustomCategoryComment("Hive Creep", "\nEverything involving Hive Creep\n");
        config.setCategoryRequiresWorldRestart("Hive Creep", true);
        String CATEGORYTHREE = "Drop Pods";
        config.addCustomCategoryComment("Drop Pods", "\nEverything involving wyrm spawns from the Invasion system.\n");
        config.setCategoryRequiresWorldRestart("Drop Pods", false);
        minWyrmsHexepod = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Hexe min spawns", (String)"Minimum wyrms to spawn from Hexe pods. Will still always spawn at least 1 wyrm. Hexe pods always spawn wyrmlings that grow into various castes of wyrms except royals. Default: 1", (int)ConfigBase.presetInts(1, 2, 3, id));
        maxWyrmsHexepod = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Hexe max spawns", (String)"Maximum wyrms to spawn from Hexe pods. Default: 3", (int)ConfigBase.presetInts(3, 6, 7, id));
        if (minWyrmsHexepod < 1) {
            minWyrmsHexepod = 1;
        }
        minWyrmsCallouspod = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Callous min spawns", (String)"Minimum wyrms to spawn from Callous pods. Default: 1", (int)ConfigBase.presetInts(1, 2, 2, id));
        maxWyrmsCallouspod = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Callous max spawns", (String)"Maximum wyrms to spawn from Callous pods. Default: 2", (int)ConfigBase.presetInts(2, 3, 4, id));
        if (minWyrmsCallouspod < 1) {
            minWyrmsCallouspod = 1;
        }
        invasionStartMode = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Invasion Start Mode", (String)"0 = Random chance, 1 = after x days, 2 = hybrid (time & chance). Default: 1", (int)ConfigBase.presetInts(1, 2, 1, id));
        invasionStartTime = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Invasion Start Time", (String)"Number of days until wyrms can start to invade. Default: 10", (int)ConfigBase.presetInts(7, 10, 10, id));
        invasionStartChance = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Invasion Start Chance", (String)"1 in x chance to occur each day before wyrms start invading. Default: 10", (int)10);
        invasionEventFrequency = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Invasion Event Frequency", (String)"Every x minutes, an invasion event takes place. Default: 7", (int)ConfigBase.presetInts(7, 10, 9, id));
        visitorDropPodFrequency = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Visitor drop pod frequency", (String)"Delay for each drop pod spawn from The Visitor. Default: 3000", (int)ConfigBase.presetInts(3000, 3500, 2500, id));
        visitorDropPodFrequencyVariation = CFG.createConfigInt((Configuration)config, (String)"Drop Pods", (String)"Visitor drop pod frequency variation", (String)"Random variation added to the drop delays, adds -x to x ticks to delay. Default: 500", (int)ConfigBase.presetInts(500, 550, 250, id));
        invasionEnabled = CFG.createConfigBool((Configuration)config, (String)"Invasion", (String)"Invasion enabled", (String)"Enables the invasion system. Many functions of the mod will not work if this is off, including other sub-systems. Default: true", (boolean)true);
        if (!invasionEnabled) {
            WyrmsOfNyrus.logger.info("Invasion module has been disabled");
        }
        invasionStartsNaturally = CFG.createConfigBool((Configuration)config, (String)"Invasion", (String)"Invasion starts naturally", (String)"Allows the invasion to start naturally without needing admin commands. Default: true", (boolean)true);
        iPointsIStage1Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 1 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Phase 0 takes place below this. Default: 1000", (int)1000);
        iPointsIStage2Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 2 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Default: 5000", (int)5000);
        iPointsIStage3Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 3 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Default: 10000", (int)10000);
        iPointsIStage4Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 4 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Default: 50000", (int)50000);
        iPointsIStage5Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 5 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Default: 100000", (int)100000);
        iPointsIStage6Threshold = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Stage 6 Invasion Point threshold", (String)"How many points are required to reach this phase of the alien invasion. Default: 2500000", (int)2500000);
        Invasion.validatePhaseThresholds();
        int invLvl = 0;
        invasionStage0EventPool = Invasion.invasionEventPool(invLvl, config, "Invasion", new String[]{" "});
        Invasion.makeEventPool(invasionStage0EventPool, invLvl);
        invasionStage1EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage1poolDef);
        Invasion.makeEventPool(invasionStage1EventPool, invLvl);
        invasionStage2EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage2poolDef);
        Invasion.makeEventPool(invasionStage2EventPool, invLvl);
        invasionStage3EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage3poolDef);
        Invasion.makeEventPool(invasionStage3EventPool, invLvl);
        invasionStage4EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage3poolDef);
        Invasion.makeEventPool(invasionStage4EventPool, invLvl);
        invasionStage5EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage3poolDef);
        Invasion.makeEventPool(invasionStage5EventPool, invLvl);
        invasionStage6EventPool = Invasion.invasionEventPool(++invLvl, config, "Invasion", invstage3poolDef);
        Invasion.makeEventPool(invasionStage6EventPool, invLvl);
        WyrmsOfNyrus.logger.info("All invasion event pools have been populated");
        invadeableDimensions = config.get("Invasion", "Invade-able dimensions", invasiondims, "The dimensions (in their numerical IDs) in which wyrms are able to invade. Note that the dimension still must be a surface dimension in order for certain events to work! Default: 0,1").getIntList();
        maxEventDistance = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Max event distance", (String)"All invasion events take place a certain distance away from the player. Increasing this range makes it less likely that events happen near the player, but may cause performance hitches due to potential chunkloading. Usually keep this number in increments of 16 (Chunk x/z size). Default is calculated for Minecraft's usual 12 chunk render radius. Default: 192", (int)192);
        invasionPointsPerKill = CFG.createConfigInt((Configuration)config, (String)"Invasion", (String)"Invasion Points Per Kill", (String)"Wyrms gain invasion points for every kill. Set this to 0 to disable this feature entirely. Default: 1", (int)ConfigBase.presetInts(1, 1, 2, id));
        probingEnabled = CFG.createConfigBool((Configuration)config, (String)"Invasion", (String)"Probing enabled", (String)"Probers deal heavy damage and every kill advances the invasion by 5 points, compared to only one, IF the entity can be sampled (hit) more than once. One-shots or each hit adds 2 points. They also have longer aggro range and fly faster. Set to false to disable this feature and make probers less dangerous. Default: true", (boolean)true);
        creepConvertList = CFG.createConfigStringList((Configuration)config, (String)"Hive Creep", (String)"Mob conversion list", (String)"List of mobs to convert into specific Creeped entities. If something isn't specified, it will fall back on the old system. If a provided entity on this list can also be covered by the old system, this list will act as an override. Make a new line for each entry. Malformed configs here will be reported in the log as errors. Format: OriginalEntityMod:ResourceName;ThisMod:ResourceName", (String[])creepConversionDef);
        creepConversionKeepNametag = CFG.createConfigBool((Configuration)config, (String)"Hive Creep", (String)"Mob conversion keeps nametags", (String)"If hive creep should preserve the entity's nametag information. Enabling this is kinda cheating, since it will reveal the location of the mob. Default: true", (boolean)ConfigBase.presetBools(true, false, false, id));
        creepTickRate = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Creep tickrate", (String)"Every n world ticks, hive creep blocks will tick and roll to see if they spread or not. 20 ticks = 1 second. Default: 500", (int)500);
        creepBlocksProduceGas = CFG.createConfigBool((Configuration)config, (String)"Hive Creep", (String)"Creep decay produces radioactive gas", (String)"If enabled, if a hive creep block decays and there is open air above it, it releases a radioactive gas. Default: false", (boolean)ConfigBase.presetBools(false, false, true, id));
        creepEnabled = CFG.createConfigBool((Configuration)config, (String)"Hive Creep", (String)"Creep enabled", (String)"If The Creep is enabled or not. This stops spread. Default: true", (boolean)true);
        if (!creepEnabled) {
            WyrmsOfNyrus.logger.info("Creep module has been disabled");
        }
        creepSpreadRate = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Creep spread speed", (String)"1 to n chance every tick that a hive creep blocks actually does something. Some blocks will tick much slower, like creepstone. Increase this number if you're seeing TPS drops. Default: 20", (int)20);
        creepSpreadPoints = CFG.createConfigDouble((Configuration)config, (String)"Hive Creep", (String)"Creep spread points", (String)"Every time a creep block is created, the invasion points increase. If Invasion is not enabled, this won't work at all. It is recommended you should keep this number as a decimal unless if you want pain... Default: 0.015", (double)0.015);
        creepSpreadMaxHardness = CFG.createConfigDouble((Configuration)config, (String)"Hive Creep", (String)"Creep spread max hardness", (String)"Maximum hardness of a block that can be infested. Can automatically generate a blacklist this way for other mods. Default: 10", (double)10.0);
        creepInactivityChance = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Creep decay chance", (String)"If a hive creep block fails to find a suitable block to creep, there is a 1 in x chance that it will decay into a hive block. Lower this value if you're experiencing TPS drops. Default: 30", (int)30);
        invalidBlocksForCreepspread = CFG.createConfigStringList((Configuration)config, (String)"Hive Creep", (String)"Creepable block blacklist", (String)"Blacklist of blocks hive creep can not spread to. Blocks that are not considered a full block by the MC engine do not need to be included here.\nWARNING: EXPERIMENTAL FEATURE. Disabled/enable in the 2nd config option. Is automatically set to true in development builds.", (String[])iBdef);
        CSBlockBLEnabled = CFG.createConfigBool((Configuration)config, (String)"Hive Creep", (String)"Creepable block blacklist enabled", (String)"Enables the creepable block blacklist.", (boolean)true);
        Invasion.FinalizeiBdef();
        normCreepwyrmCreepSpeed = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Creepwyrm creep speed", (String)"The speed at which normal Creepwyrms spread The Creep. Every x entity updates, the creepwyrm runs a check and creeps over a valid block if found. Lower this to make it faster, or increase it even further to make creepwyrms do their thing a lot slower. Default: 200", (int)ConfigBase.presetInts(200, 150, 125, id));
        direCreepwyrmCreepSpeed = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Dire Creepwyrm creep speed", (String)"The speed at which Dire Creepwyrms spread The Creep. Every x entity updates, the creepwyrm runs a check and creeps over a valid block if found. Lower this to make it faster, or increase it even further to make creepwyrms do their thing a lot slower./n(WARNING: AS THIS MOB CREATES ACTIVE CREEPED BLOCKS, KEEP THIS VALUE VERY HIGH TO AVOID BLOCK UPDATE SPAM BUILDUP) Default: 1800", (int)1800);
        creephiveCreepSpeed = CFG.createConfigInt((Configuration)config, (String)"Hive Creep", (String)"Creep Hive creep speed", (String)"The speed at which Creep Hives spread The Creep. Every x entity updates, the creep hive runs a check and creeps over a valid block if found. Lower this to make it faster, or increase it even further to make creep hives do their thing a lot slower./n(WARNING: AS THIS MOB CREATES ACTIVE CREEPED BLOCKS, KEEP THIS VALUE VERY HIGH TO AVOID BLOCK UPDATE SPAM BUILDUP) Default: 1800", (int)1800);
    }

    public static boolean isCreepEnabled() {
        return creepEnabled;
    }

    public static void FinalizeiBdef() {
        invalidBlocks = BlacklistUtil.castToBlockBL((String[])invalidBlocksForCreepspread);
    }

    public static void validatePhaseThresholds() {
        WyrmsOfNyrus.logger.debug("Validating invasion stage point thresholds...");
        boolean validationFailed = false;
        if (iPointsIStage1Threshold > iPointsIStage2Threshold) {
            validationFailed = true;
            WyrmsOfNyrus.logger.warn("Stage 1 Invasion Point threshold was more than Stage 2 Invasion Point threshold, resetting to default...");
        } else if (iPointsIStage2Threshold > iPointsIStage3Threshold) {
            validationFailed = true;
            WyrmsOfNyrus.logger.warn("Stage 2 Invasion Point threshold was more than Stage 3 Invasion Point threshold, resetting to default...");
        } else if (iPointsIStage3Threshold > iPointsIStage4Threshold) {
            validationFailed = true;
            WyrmsOfNyrus.logger.warn("Stage 3 Invasion Point threshold was more than Stage 4 Invasion Point threshold, resetting to default...");
        } else if (iPointsIStage4Threshold > iPointsIStage5Threshold) {
            validationFailed = true;
            WyrmsOfNyrus.logger.warn("Stage 4 Invasion Point threshold was more than Stage 5 Invasion Point threshold, resetting to default...");
        } else if (iPointsIStage5Threshold > iPointsIStage6Threshold) {
            validationFailed = true;
            WyrmsOfNyrus.logger.warn("Stage 5 Invasion Point threshold was more than Stage 6 Invasion Point threshold, resetting both to default...");
        }
        if (validationFailed) {
            WyrmsOfNyrus.logger.warn("Had to fall back to default point thresholds to avoid logic errors. Please fix your configuration file to use custom thresholds again.");
            iPointsIStage1Threshold = 1000;
            iPointsIStage2Threshold = 5000;
            iPointsIStage3Threshold = 10000;
            iPointsIStage4Threshold = 50000;
            iPointsIStage5Threshold = 100000;
            iPointsIStage6Threshold = 2500000;
        }
        WyrmsOfNyrus.logger.debug("All invasion stage point thresholds are validated.");
    }

    public static String[] invasionEventPool(int level, Configuration c, String CATEGORY, String[] eventPoolDefault) {
        return c.get(CATEGORY, "Stage " + level + " event pool", eventPoolDefault, "Remove entries or add entries to modify this stage's event pool. [ Min event ID: 0 | Max event ID: 6 ]\n\nFormat: 1,10 OR 1,10,40,3,3\nThis creates an event with the ID of 1 with a weight of 10.\nIn the latter format, this creates an event with the ID of 1 with a weight of 10, giving it 40 seconds per stage, with 3 stages total and takes place at level 3").getStringList();
    }

    public static void makeEventPool(String[] configLines, int stage) {
        ArrayList<Integer> iList = new ArrayList<Integer>();
        WyrmsOfNyrus.logger.info("[CONFIGURATION] Making event pool for stage " + stage);
        if (configLines == null) {
            WyrmsOfNyrus.logger.error(String.format("[CONFIGURATION] Invasion event pool for stage %d returned null. Was the field left blank, or does it not exist?", stage));
        }
        assert (configLines != null);
        for (String s : configLines) {
            WyrmsOfNyrus.logger.debug(s);
            iList.clear();
            String[] sList = s.split(",");
            int liLength = sList.length;
            if (liLength == 2 || liLength == 5) {
                for (String sItem : sList) {
                    iList.add(Integer.parseInt(sItem));
                    WyrmsOfNyrus.logger.debug("iList building: " + iList);
                }
                int seconds = 50;
                int stages = 2;
                int level = 1;
                int ID = (Integer)iList.get(0);
                int weight = (Integer)iList.get(1);
                if (iList.toArray().length == 5) {
                    seconds = (Integer)iList.get(2);
                    stages = (Integer)iList.get(3);
                    level = (Integer)iList.get(4);
                }
                WyrmsOfNyrus.logger.debug(String.format("Attempted to add event as ID %d, %d stages, %d levels, %d seconds stage update, invasion level %d, and with a weight of %d", ID, stages, level, seconds, stage, weight));
                InvasionEvents.addEvent(ID, stages, level, seconds, stage, weight);
                continue;
            }
            if (stage <= 0) continue;
            WyrmsOfNyrus.logger.error("[CONFIGURATION] User error reported at string " + s + " out of whole list " + Arrays.toString(configLines) + ", safely skipping. Did you give a malformed line?");
        }
    }

    static {
        invasiondims = new int[]{0, 1};
        iBdef = new String[]{"minecraft:furnace", "minecraft:brick_block", "minecraft:bone_block", "minecraft:bedrock", "minecraft:concrete", "minecraft:concrete_powder", "minecraft:end_bricks", "minecraft:end_stone", "minecraft:glass", "minecraft:jukebox", "minecraft:nether_brick", "minecraft:red_nether_brick", "minecraft:noteblock", "minecraft:observer", "minecraft:obsidian", "minecraft:packed_ice", "minecraft:prismarine", "minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:quartz_block", "minecraft:sponge", "minecraft:stained_glass", "minecraft:wool", "minecraft:stonebrick"};
        invstage1poolDef = new String[]{"1,5,30,3,1", "1,5,30,4,1", "2,10,10,5,1", "2,10,10,5,2", "6,10,10,3,1", "3,10,40,5,1", "7,5,25,3,1"};
        invstage2poolDef = new String[]{"1,5,30,3,1", "1,5,30,4,1", "4,10,10,5,3", "3,10,30,5,2", "2,5,20,5,4", "4,10,20,3,1", "6,5,10,4,2", "6,2,10,5,1", "7,5,25,3,1"};
        invstage3poolDef = new String[]{"1,2,25,3,2", "5,5,60,3,1", "2,10,10,5,3", "3,10,30,5,4", "5,2,60,4,1", "4,30,10,3,1", "6,5,10,5,2", "6,2,10,5,3", "7,5,25,3,1"};
        creepConversionDef = new String[]{"minecraft:polar_bear;wyrmsofnyrus:prime", "srparasites:sim_human;wyrmsofnyrus:creepedhumanoid", "srparasites:sim_villager;wyrmsofnyrus:creepedhumanoid", "srparasites:sim_adventurer;wyrmsofnyrus:creepedhumanoid", "srparasites:sim_enderman;wyrmsofnyrus:creepedhumanoid", "srparasites:worker;wyrmsofnyrus:creepedhumanoid", "srparasites:thrall;wyrmsofnyrus:creepedhumanoid", "srparasites:sim_cow;wyrmsofnyrus:minos", "srparasites:sim_sheep;wyrmsofnyrus:creepedbiter", "srparasites:sim_wolf;wyrmsofnyrus:creepedbiter", "srparasites:sim_pig;wyrmsofnyrus:creepedbiter", "srparasites:sim_horse;wyrmsofnyrus:creepedbiter", "srparasites:sim_bear;wyrmsofnyrus:creepedbiter", "srparasites:sim_bigspider;wyrmsofnyrus:crawler", "srparasites:rupter;wyrmsofnyrus:crawler", "srparasites:mangler;wyrmsofnyrus:crawler", "srparasites:crux;wyrmsofnyrus:prime", "srparasites:heed;wyrmsofnyrus:prime", "srparasites:carrier_heavy;wyrmsofnyrus:prime", "srparasites:pri_longarms;wyrmsofnyrus:prime", "srparasites:pri_manducater;wyrmsofnyrus:prime", "srparasites:pri_reeker;wyrmsofnyrus:prime", "srparasites:pri_yelloweye;wyrmsofnyrus:prime", "srparasites:pri_summoner;wyrmsofnyrus:prime", "srparasites:pri_bolster;wyrmsofnyrus:prime", "srparasites:pri_arachnida;wyrmsofnyrus:prime", "srparasites:pri_devourer;wyrmsofnyrus:prime", "srparasites:fer_enderman;wyrmsofnyrus:creepedhumanoid", "srparasites:fer_human;wyrmsofnyrus:creepedhumanoid", "srparasites:fer_villager;wyrmsofnyrus:creepedhumanoid", "srparasites:fer_horse;wyrmsofnyrus:creepedbiter", "srparasites:fer_cow;wyrmsofnyrus:creepedbiter", "srparasites:fer_bear;wyrmsofnyrus:prime", "srparasites:fer_pig;wyrmsofnyrus:creepedbiter", "srparasites:fer_sheep;wyrmsofnyrus:creepedbiter", "srparasites:fer_wolf;wyrmsofnyrus:creepedbiter", "srparasites:gnat;wyrmsofnyrus:crawler", "srparasites:pri_tozoon;wyrmsofnyrus:prime", "srparasites:pri_vermin;wyrmsofnyrus:prime"};
    }
}

