/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.Constants;
import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.advancements.Advancements;
import com.vetpetmon.wyrmsofnyrus.compat.HBM;
import com.vetpetmon.wyrmsofnyrus.compat.HBMFunctions;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrmFlying;
import com.vetpetmon.wyrmsofnyrus.entity.IEntityVoidwyrm;
import com.vetpetmon.wyrmsofnyrus.entity.MobEntityBase;
import com.vetpetmon.wyrmsofnyrus.entity.ability.painandsuffering.WyrmBreakDoors;
import com.vetpetmon.wyrmsofnyrus.entity.ability.painandsuffering.wyrmDeathSpecial;
import com.vetpetmon.wyrmsofnyrus.entity.ability.painandsuffering.wyrmKillBonuses;
import com.vetpetmon.wyrmsofnyrus.entity.ai.EntitySwimAndDiveAI;
import com.vetpetmon.wyrmsofnyrus.entity.ai.gestalt.GestaltFollow;
import com.vetpetmon.wyrmsofnyrus.entity.ai.gestalt.GestaltHostMind;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreeped;
import com.vetpetmon.wyrmsofnyrus.entity.variant.VariantPurged;
import com.vetpetmon.wyrmsofnyrus.handlers.WoNSpawner;
import com.vetpetmon.wyrmsofnyrus.locallib.DifficultyStats;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;

public abstract class EntityWyrm
extends MobEntityBase
implements IMob {
    private static final DataParameter<Boolean> HAS_TARGET = EntityDataManager.func_187226_a(EntityWyrm.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RAGECOOLDOWN = EntityDataManager.func_187226_a(EntityWyrm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LOCALRESOURCES = EntityDataManager.func_187226_a(EntityWyrm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHELLHEALTH = EntityDataManager.func_187226_a(EntityWyrm.class, (DataSerializer)DataSerializers.field_187192_b);
    private double potency = 0.0;
    private double radAuraRadius = 2.0;
    public int casteType;
    private boolean hasShell = false;
    public Vec3d accel = Vec3d.field_186680_a;

    public void setRadAuraRadius(double radAuraRadius) {
        this.radAuraRadius = radAuraRadius;
    }

    public double getRadAuraRadius() {
        return this.radAuraRadius;
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean hasShellFunctionality() {
        return false;
    }

    public boolean hasShell() {
        return this.hasShell;
    }

    public void setShellStatus(boolean flag) {
        this.hasShell = flag;
    }

    public int getShellHP() {
        return (Integer)this.func_184212_Q().func_187225_a(SHELLHEALTH);
    }

    public void setShellHP(int input) {
        this.func_184212_Q().func_187227_b(SHELLHEALTH, (Object)input);
    }

    public double getPotency() {
        return this.potency;
    }

    public void setPotency(double potency) {
        this.potency = potency;
    }

    public EntityWyrm(World worldIn) {
        super(worldIn);
        this.field_70178_ae = false;
        this.func_184644_a(PathNodeType.LAVA, -0.5f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -0.5f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -0.5f);
        if (Arrays.asList(new int[][]{this.getLegalVariants()}).contains(18)) {
            WoNSpawner.WyrmsWithPurgedVariant.add(this);
        }
    }

    @Override
    public boolean func_70687_e(PotionEffect potion) {
        if (potion.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potion);
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.getVariant().onDeath(this);
        this.getVariant().addPressureScore();
        if (!(this.getVariant() instanceof VariantPurged)) {
            WoNVars.worldVariables.addWyrmsKilled(this.field_70170_p);
        }
        wyrmDeathSpecial.wyrmDeathSpecial((Entity)this, this.func_180425_c(), this.field_70170_p, this.getPotency());
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public double getInvasionDifficulty() {
        return WoNVars.worldVariables.get((World)this.field_70170_p).wyrmInvasionDifficulty;
    }

    public float genDifficulty() {
        return (float)this.getInvasionDifficulty();
    }

    public void setStats(MobStatConfigs matrix) {
        float diff = this.genDifficulty();
        float[] mutators = Constants.variantObjs[this.getVariantInt()].getModifiedStats(true, (World)DimensionManager.getWorld((int)0));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getMatrix().getStat(StatType.HEALTH) * Radiogenetics.wyrmVitality);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)this.getMatrix().getStat(StatType.DEFENSE) * Radiogenetics.wyrmResistance);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getMatrix().getStat(StatType.ATTACK) * Radiogenetics.wyrmStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)matrix.getStat(StatType.SPEED));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)matrix.getStat(StatType.KBR));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    protected void simpleAI() {
        if (!EntityWyrm.getSimpleAI()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        }
    }

    protected void isSapient() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new WyrmBreakDoors((EntityLiving)this, 200));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
    }

    protected void makeAllTargets() {
        this.afterPlayers();
        if (EntityWyrm.getAttackAnimals()) {
            this.afterAnimals();
        }
        if (EntityWyrm.getAttackVillagers()) {
            this.afterVillagers();
        }
        if (EntityWyrm.getAttackMobs()) {
            this.afterMobs();
        }
        if (Loader.isModLoaded((String)"lycanitesmobs") && EntityWyrm.getAttackMobs()) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 2, true, false, target -> target != null && !(target instanceof EntityCreeper) && !(target instanceof EntityWyrm)));
        }
    }

    protected void afterMobs() {
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 2, true, false, target -> {
            if (EntityWyrm.getWillAttackCreepers()) {
                return !(target instanceof EntityWyrm);
            }
            return !(target instanceof EntityCreeper) && !(target instanceof EntityWyrm);
        }));
    }

    protected boolean partakesInGestalt() {
        return true;
    }

    protected void enabledGestalt() {
        if (this.partakesInGestalt()) {
            this.field_70714_bg.func_75776_a(3, new GestaltFollow((EntityCreature)this, EntityPlayer.class, 1.0, 128, 24, e -> true));
        }
    }

    public int getRageCooldown() {
        return (Integer)this.func_184212_Q().func_187225_a(RAGECOOLDOWN);
    }

    public void setRageCooldown(int input) {
        this.func_184212_Q().func_187227_b(RAGECOOLDOWN, (Object)input);
    }

    public int getResources() {
        return (Integer)this.func_184212_Q().func_187225_a(LOCALRESOURCES);
    }

    public void setResources(int input) {
        this.func_184212_Q().func_187227_b(LOCALRESOURCES, (Object)input);
    }

    public void rageEffect(EntityLivingBase ogEntity) {
        ogEntity.func_70653_a((Entity)ogEntity, 3.0f, 2.0, 2.0);
        DifficultyStats.applyPotionEffect((Entity)this, MobEffects.field_76420_g, 3, 2);
        DifficultyStats.applyPotionEffect((Entity)this, MobEffects.field_76429_m, 3, 1);
        this.func_184185_a(SoundRegistry.wyrmannoyed, 0.9f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f);
        if (ogEntity instanceof EntityPlayerMP) {
            EntityPlayerMP playerEntity = (EntityPlayerMP)ogEntity;
            Advancements.grantAchievement(playerEntity, Advancements.theycandothat);
        }
        this.setRageCooldown(AI.rageCooldownMax * 20);
    }

    public void rageEffect() {
        DifficultyStats.applyPotionEffect((Entity)this, MobEffects.field_76420_g, 3, 2);
        DifficultyStats.applyPotionEffect((Entity)this, MobEffects.field_76429_m, 3, 1);
        this.func_184185_a(SoundRegistry.wyrmannoyed, 0.9f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f);
        this.setRageCooldown(AI.rageCooldownMax * 20);
    }

    public boolean func_191990_c(EntityPlayer playerIn) {
        switch (this.casteType) {
            case 1: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HAS_TARGET, (Object)false);
        this.func_184212_Q().func_187214_a(RAGECOOLDOWN, (Object)0);
        this.func_184212_Q().func_187214_a(LOCALRESOURCES, (Object)0);
        this.func_184212_Q().func_187214_a(SHELLHEALTH, (Object)0);
    }

    public boolean hasAttackTarget() {
        if (this.field_70170_p.field_72995_K) {
            return (Boolean)this.field_70180_af.func_187225_a(HAS_TARGET);
        }
        return this.func_70638_az() != null && !this.func_70638_az().field_70128_L;
    }

    public boolean attackEntityAsMobO(Entity entityIn, boolean flag) {
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag) {
            int j;
            if (i > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() == null) {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)false);
        } else {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)true);
        }
        this.setRageCooldown(this.getRageCooldown() - 1);
        if (HBM.isEnabled()) {
            HBMFunctions.createRadAura((EntityLivingBase)this, this.getRadAuraRadius(), this.getVariant().radAuraStrength());
        }
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        wyrmKillBonuses.pointIncrease(this.field_70170_p);
    }

    public boolean checkDamageTypes(DamageSource source) {
        if (this instanceof EntityCreeped) {
            if (source == DamageSource.field_76379_h && Radiogenetics.creepedImmuneToFalling && this.casteType != 9) {
                return false;
            }
            if (source.func_94541_c() && Radiogenetics.creepedImmuneToExplosions) {
                return false;
            }
            if (source == DamageSource.field_76367_g && Radiogenetics.creepedImmuneToCacti) {
                return false;
            }
        } else {
            if (source == DamageSource.field_76379_h && Radiogenetics.immuneToFalling && this.casteType != 9) {
                return false;
            }
            if (source.func_94541_c() && Radiogenetics.immuneToExplosions) {
                return false;
            }
            if (source == DamageSource.field_76367_g && Radiogenetics.immuneToCacti) {
                return false;
            }
        }
        return source != DamageSource.field_76369_e && source != DamageSource.field_76368_d;
    }

    public boolean shellProcessing(DamageSource source, float amount) {
        int ShellHP = this.getShellHP();
        if (ShellHP > 1) {
            this.setShellStatus(true);
        }
        if (this.hasShell()) {
            if (ShellHP > 0) {
                if (source.func_76346_g() instanceof EntityPlayer) {
                    this.func_184185_a(SoundRegistry.shellhit, 1.0f, 1.0f);
                    this.setShellHP(ShellHP - (int)amount);
                    return false;
                }
                if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
                    this.func_184185_a(SoundRegistry.shellhit, 1.0f, 1.5f);
                } else {
                    if (source == DamageSource.field_76369_e || source == DamageSource.field_76368_d) {
                        return false;
                    }
                    this.func_184185_a(SoundRegistry.shellhit, 1.0f, 1.0f);
                    this.setShellHP(ShellHP - (int)(amount / 3.0f));
                }
            } else {
                this.func_184185_a(SoundRegistry.shellbreak, 1.0f, 1.0f);
                this.setShellStatus(false);
                if (this.canEnrage() && AI.rageEnabled) {
                    this.rageEffect();
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityWyrm || source.func_76364_f() instanceof EntityWyrm) {
            return false;
        }
        if (this.getVariant().damageImmunity(source)) {
            return false;
        }
        float totalDamage = amount;
        if (source == DamageSource.field_76370_b && !this.hasShell()) {
            totalDamage *= 3.0f;
        }
        if (!this.checkDamageTypes(source)) {
            return false;
        }
        if (this.shellProcessing(source, amount)) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase && source.func_76346_g() != null && !(this instanceof IEntityVoidwyrm)) {
            EntityLivingBase entity = (EntityLivingBase)source.func_76346_g();
            EntityLivingBase ogEntity = this.func_70638_az();
            if (entity != null && ogEntity != null && !(entity instanceof EntityWyrm)) {
                EntityPlayer player;
                if (entity instanceof EntityPlayer && AI.gestaltUseInfamy && !this.field_70170_p.field_72995_K && (!(player = (EntityPlayer)entity).func_184812_l_() || !player.func_175149_v() && (double)totalDamage > AI.infamyRequiredDamageFloor)) {
                    GestaltHostMind.increaseAttentionLevel(this.field_70170_p);
                }
                if (entity instanceof EntityPlayer) {
                    EntityPlayer playerEn = (EntityPlayer)entity;
                    if (!playerEn.func_175149_v() && !playerEn.func_184812_l_()) {
                        GestaltHostMind.setKollectiveTarget((EntityLivingBase)playerEn);
                        this.func_70624_b(GestaltHostMind.getKollectiveTarget());
                    }
                } else {
                    List nearbyWyrms;
                    this.func_70624_b(entity);
                    if (RNG.getIntRangeInclu((int)1, (int)10) == 2 && !(nearbyWyrms = this.field_70170_p.func_72872_a(EntityWyrm.class, new AxisAlignedBB(this.field_70165_t - 20.0, this.field_70163_u - 10.0, this.field_70161_v - 20.0, this.field_70165_t + 20.0, this.field_70163_u + 10.0, this.field_70161_v + 20.0))).isEmpty()) {
                        for (EntityWyrm ent : nearbyWyrms) {
                            if (ent == null) continue;
                            ent.func_70624_b(entity);
                        }
                    }
                }
                if (!(this instanceof EntityCreeped) && this.getRageCooldown() <= 0 && this.canEnrage() && AI.rageEnabled && entity != ogEntity && this.func_70032_d((Entity)entity) < 5.0f) {
                    this.rageEffect(ogEntity);
                }
            }
        }
        if (source.func_76352_a()) {
            totalDamage *= this instanceof EntityWyrmFlying ? 1.0f : (float)Radiogenetics.flyingWyrmProjWeakness;
        }
        this.getVariant().onHit(this);
        return super.func_70097_a(source, totalDamage);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.enabledGestalt();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.85));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntitySwimAndDiveAI((EntityLiving)this, 0.1257f));
    }

    private boolean blockIsWater(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public boolean isGrounded() {
        return this.field_70170_p.func_175665_u(new BlockPos(this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o() - 1, this.func_180425_c().func_177952_p()));
    }

    public static double toPitch(Vec3d vec) {
        return Math.toDegrees(EntityWyrm.cosAngle(vec, new Vec3d(0.0, 1.0, 0.0).func_186678_a(-1.0)));
    }

    public static double cosAngle(Vec3d a, Vec3d b) {
        double dot = a.func_72430_b(b);
        double cos = dot / (a.func_72433_c() * b.func_72433_c());
        return Math.acos(cos);
    }

    public Vec3d getVelocity() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public boolean inBlock() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            int j = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f));
            if (!this.field_70170_p.func_180495_p(new BlockPos(j, k = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e() + (double)f1)), l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f2)))).func_185915_l() && !this.func_70090_H()) continue;
            return true;
        }
        return false;
    }

    public float getSoundVolumeNonProt() {
        return this.func_70599_aP();
    }
}

