/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity;

import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.MobEntityBase;
import com.vetpetmon.wyrmsofnyrus.entity.WyrmRegister;
import net.minecraft.util.ResourceLocation;

public interface IAnimatedEntity {
    default public String getName(MobEntityBase ent) {
        return WyrmRegister.wyrmIDs[this.getID(ent)][0];
    }

    default public String getVariantName(MobEntityBase ent) {
        return ent.getVariant().getVariantName();
    }

    default public ResourceLocation getVariantTextureLocation(MobEntityBase ent) {
        EntityWyrm wyrm;
        String texPath = this.getVariantName(ent);
        if (ent instanceof EntityWyrm && (wyrm = (EntityWyrm)ent).hasShellFunctionality() && !wyrm.hasShell()) {
            texPath = texPath + "vuln";
        }
        return new ResourceLocation("wyrmsofnyrus", "textures/entity/" + this.getName(ent) + "/" + texPath + ".png");
    }

    default public ResourceLocation getGlowTextureLocation(MobEntityBase ent) {
        EntityWyrm wyrm;
        String texPath = this.getVariantName(ent);
        if (ent instanceof EntityWyrm && (wyrm = (EntityWyrm)ent).hasShellFunctionality() && !wyrm.hasShell()) {
            texPath = texPath + "vuln";
        }
        return new ResourceLocation("wyrmsofnyrus", "textures/entity/" + this.getName(ent) + "/" + texPath + "_glow.png");
    }

    default public void withID(MobEntityBase ent, int ID) {
        ent.ID = ID;
    }

    default public int getID(MobEntityBase ent) {
        return ent.ID;
    }

    default public Integer getAnimationState(MobEntityBase ent) {
        return ent.getState();
    }

    default public void setAnimationState(MobEntityBase ent, int flag) {
        ent.setState(flag);
    }

    default public boolean getIdleState(MobEntityBase ent) {
        return ent.isIdle();
    }
}

