/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity;

import com.google.common.primitives.Ints;
import com.vetpetmon.wyrmsofnyrus.Constants;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.compat.HBM;
import com.vetpetmon.wyrmsofnyrus.compat.SRP;
import com.vetpetmon.wyrmsofnyrus.compat.SRR;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.config.Modifiers;
import com.vetpetmon.wyrmsofnyrus.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.entity.EntityHitbox;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.IAnimatedEntity;
import com.vetpetmon.wyrmsofnyrus.entity.IEntityConfigurable;
import com.vetpetmon.wyrmsofnyrus.entity.IEntityVoidwyrm;
import com.vetpetmon.wyrmsofnyrus.entity.IHitboxedEntity;
import com.vetpetmon.wyrmsofnyrus.entity.ai.EntityAITargetDetection;
import com.vetpetmon.wyrmsofnyrus.entity.ai.EntityAITargetJudger;
import com.vetpetmon.wyrmsofnyrus.entity.variant.WyrmVariant;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import java.lang.reflect.Constructor;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MobEntityBase
extends EntityMob
implements IAnimatedEntity,
IMob,
IEntityConfigurable,
IHitboxedEntity {
    protected static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> FIRSTSPAWN = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected boolean idle;
    protected boolean prepToTeleport;
    protected int stillTimer;
    protected int teleportTimer;
    protected double delta;
    public int ID;
    private static final DataParameter<Integer> ATTACKID = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_TARGET = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private String[] animationNames;
    private boolean canStrafe;
    private int[] legalVariants = new int[]{0};
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private int timeUntilDetonation;
    private boolean hasPrimed = false;
    private float entitySize = 1.0f;
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(MobEntityBase.class, (DataSerializer)DataSerializers.field_187193_c);
    public EntityHitbox[] hitboxes;
    public float prevHitboxScale;

    public Integer getState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setState(Integer flag) {
        this.field_70180_af.func_187227_b(STATE, (Object)flag);
    }

    public boolean getFirstSpawn() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRSTSPAWN);
    }

    public void setFirstSpawn(boolean flag) {
        this.field_70180_af.func_187227_b(FIRSTSPAWN, (Object)flag);
    }

    public boolean isIdle() {
        return this.idle;
    }

    public boolean isPrepToTeleport() {
        return this.prepToTeleport;
    }

    public void setPrepToTeleport(boolean prepToTeleport) {
        this.prepToTeleport = prepToTeleport;
    }

    public int getTeleportTimer() {
        return this.teleportTimer;
    }

    public void setTeleportTimer(int teleportTimer) {
        this.teleportTimer = teleportTimer;
    }

    public void tickTeleportTimer() {
        --this.teleportTimer;
    }

    public void setAttack(int attackID) {
        this.func_184212_Q().func_187227_b(ATTACKID, (Object)attackID);
    }

    public int getAttack() {
        return (Integer)this.func_184212_Q().func_187225_a(ATTACKID);
    }

    public void setAnimationNames(String[] animationArray) {
        this.animationNames = animationArray;
    }

    public String[] getAnimationNames() {
        return this.animationNames;
    }

    public Boolean getHasTarget() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_TARGET);
    }

    public void getHasTarget(boolean state) {
        this.func_184212_Q().func_187227_b(HAS_TARGET, (Object)state);
    }

    public boolean canStrafe() {
        return this.canStrafe;
    }

    public void setStrafePossibility(boolean canStrafe) {
        this.canStrafe = canStrafe;
    }

    public int[] getLegalVariants() {
        return this.legalVariants;
    }

    public int getLegalVariantsLength() {
        return this.getLegalVariants().length;
    }

    public void setLegalVariants(int[] array) {
        this.legalVariants = array;
    }

    public boolean isVariantLegal(int ID) {
        boolean isAllowed;
        switch (ID) {
            case 1: {
                isAllowed = HBM.isEnabled();
                break;
            }
            case 8: {
                isAllowed = SRP.isEnabled();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                isAllowed = this instanceof IEntityVoidwyrm;
                break;
            }
            case 18: {
                isAllowed = !this.field_70170_p.func_72935_r() && Modifiers.PURGEDACTIVE;
                break;
            }
            case 25: {
                isAllowed = SRR.isEnabled();
                break;
            }
            default: {
                isAllowed = true;
            }
        }
        return isAllowed && ArrayUtils.contains((int[])this.getLegalVariants(), (int)ID);
    }

    public void setVariant(int Index) {
        int i = Index;
        int lvl = WoNVars.worldVariables.getInvasionLevel(this.field_70170_p);
        if (!this.isVariantLegal(this.legalVariants[i])) {
            i = this.legalVariants[0];
        } else if (!ArrayUtils.contains((int[])Constants.variantsPerLevel[lvl], (int)i)) {
            i = this.legalVariants[0];
        }
        this.func_184212_Q().func_187227_b(VARIANT, (Object)this.legalVariants[i]);
        this.refreshAttributes();
    }

    public void refreshAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getMatrix().getStat(StatType.HEALTH) + this.getVariant().getStatWithMod(0)) * Radiogenetics.wyrmVitality);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(this.getMatrix().getStat(StatType.DEFENSE) + this.getVariant().getStatWithMod(1)) * Radiogenetics.wyrmResistance);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(this.getMatrix().getStat(StatType.ATTACK) + this.getVariant().getStatWithMod(2)) * Radiogenetics.wyrmStrength);
        this.func_70606_j(this.func_110143_aJ() + this.getVariant().getStatWithMod(0));
    }

    public int getVariantInt() {
        return (Integer)this.func_184212_Q().func_187225_a(VARIANT);
    }

    public int getVariantIndex() {
        return Ints.indexOf((int[])this.legalVariants, (int)this.getVariantInt());
    }

    public WyrmVariant getVariant() {
        WyrmVariant varProps = Constants.variantObjs[this.getVariantInt()];
        return varProps;
    }

    public void resetTimeUntilDetonation() {
        this.timeUntilDetonation = Radiogenetics.uraniumExplosionTimer * 60;
    }

    public int getTimeUntilDetonation() {
        return this.timeUntilDetonation;
    }

    public void tickTimeUntilDetonation() {
        --this.timeUntilDetonation;
        WyrmsOfNyrus.logger.debug("Time until detonation in ticks: " + this.getTimeUntilDetonation());
    }

    public boolean isPrimed() {
        return this.hasPrimed;
    }

    public void setPrimedStatus(boolean primed) {
        this.hasPrimed = primed;
    }

    public float getEntitySize() {
        return ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue();
    }

    public void setEntitySize(float size) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public MobEntityBase(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACKID, (Object)0);
        this.func_184212_Q().func_187214_a(HAS_TARGET, (Object)false);
        this.func_184212_Q().func_187214_a(VARIANT, (Object)0);
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(FIRSTSPAWN, (Object)true);
    }

    public boolean func_70687_e(PotionEffect potion) {
        if (!this.getVariant().potionImmunities(potion)) {
            return false;
        }
        return super.func_70687_e(potion);
    }

    public void func_70636_d() {
        if (!this.isEnabled()) {
            this.func_70106_y();
        }
        super.func_70636_d();
        this.getVariant().onLiving(this);
        if (this.field_70165_t == this.field_70169_q && this.field_70161_v == this.field_70166_s) {
            ++this.stillTimer;
            if (this.stillTimer >= 30) {
                this.idle = true;
                this.delta += 0.01;
            }
        } else {
            this.delta = 0.0;
            this.stillTimer = 0;
            this.idle = false;
        }
        if (this.hitboxes != null && this.hitboxes.length > 0) {
            this.updateHitboxes();
            this.resetHitboxes(this.func_70603_bj());
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        if (result) {
            this.getVariant().onAttack(entityIn);
        }
        return result;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("variant"));
        this.setFirstSpawn(compound.func_74767_n("firstspawn"));
        this.setEntitySize(compound.func_74760_g("size"));
        this.func_70105_a(this.getEntitySize(), this.getEntitySize());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("variant", this.getVariantIndex());
        compound.func_74776_a("size", this.getEntitySize());
        compound.func_74757_a("firstspawn", this.getFirstSpawn());
    }

    protected boolean canEnrage() {
        return true;
    }

    protected void afterWyrms() {
        this.field_70715_bh.func_75776_a(3, new EntityAITargetDetection<EntityWyrm>((EntityCreature)this, EntityWyrm.class, true, false));
    }

    protected void afterAnimals() {
        this.field_70715_bh.func_75776_a(3, new EntityAITargetDetection<EntityAnimal>((EntityCreature)this, EntityAnimal.class, true, false));
    }

    protected void afterVillagers() {
        this.field_70715_bh.func_75776_a(2, new EntityAITargetDetection<EntityVillager>((EntityCreature)this, EntityVillager.class, true, false));
    }

    protected void afterPlayers(boolean checkSight, boolean ignoreConfig) {
        if (ignoreConfig) {
            this.afterPlayers(checkSight);
        }
    }

    protected void afterPlayers(boolean checkSight) {
        if (!MobEntityBase.getWillNotAttackPlayers()) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 64.0f));
            this.field_70715_bh.func_75776_a(2, new EntityAITargetDetection<EntityPlayer>((EntityCreature)this, EntityPlayer.class, checkSight, false));
        }
    }

    protected void creepedAfterPlayers(boolean checkSight) {
        if (!MobEntityBase.getWillNotAttackPlayers()) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 64.0f));
            this.field_70715_bh.func_75776_a(2, new EntityAITargetJudger<EntityPlayer>((EntityCreature)this, EntityPlayer.class, checkSight, false));
        }
    }

    protected void afterPlayers() {
        if (!MobEntityBase.getWillNotAttackPlayers()) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 64.0f));
            this.field_70715_bh.func_75776_a(2, new EntityAITargetDetection<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0, false, false, e -> true));
        }
    }

    protected void afterInsectoids() {
        this.field_70715_bh.func_75776_a(3, new EntityAITargetDetection<EntityCaveSpider>((EntityCreature)this, EntityCaveSpider.class, true, false));
        this.field_70715_bh.func_75776_a(3, new EntityAITargetDetection<EntitySpider>((EntityCreature)this, EntitySpider.class, true, false));
        this.field_70715_bh.func_75776_a(3, new EntityAITargetDetection<EntitySilverfish>((EntityCreature)this, EntitySilverfish.class, true, false));
    }

    protected static boolean getSimpleAI() {
        return AI.performanceAIMode;
    }

    protected static boolean getAttackMobs() {
        return AI.attackMobs;
    }

    protected static boolean getAttackAnimals() {
        return AI.attackAnimals;
    }

    protected static boolean getAttackVillagers() {
        return AI.attackVillagers;
    }

    protected static boolean getWillAttackCreepers() {
        return AI.suicidalWyrms;
    }

    protected static boolean getWillNotAttackPlayers() {
        return AI.niceToPlayers;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public void duplicateThisEntity() {
        if (!this.field_70170_p.field_72995_K && this != null) {
            try {
                Class<?> c = this.getClass();
                Constructor<?> constructor = c.getDeclaredConstructor(World.class);
                Entity newInstance = (Entity)constructor.newInstance(this.field_70170_p);
                newInstance.deserializeNBT(this.serializeNBT());
                newInstance.func_184221_a(UUID.randomUUID());
                this.field_70170_p.func_72838_d(newInstance);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public boolean func_70965_a(MultiPartEntityPart dragonPart, DamageSource source, float damage) {
        return damage > 0.0f;
    }

    @Override
    public MobEntityBase getParent() {
        return this;
    }

    public void updateHitboxes() {
        for (EntityHitbox hb : this.hitboxes) {
            if (hb == null) continue;
            hb.func_70071_h_();
        }
    }

    public void resetHitboxes(float scale) {
        if (scale > this.prevHitboxScale) {
            this.prevHitboxScale = scale;
            for (EntityHitbox hb : this.hitboxes) {
                if (hb == null) continue;
                hb.resize(scale);
            }
        }
    }

    private void clearHitboxes() {
        for (EntityHitbox hb : this.hitboxes) {
            if (hb == null) continue;
            hb.func_70106_y();
            this.field_70170_p.func_72973_f((Entity)hb);
        }
    }

    public void func_70106_y() {
        if (this.hitboxes != null) {
            this.clearHitboxes();
        }
        super.func_70106_y();
    }
}

