/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ability;

import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.block.AllBlocks;
import com.vetpetmon.wyrmsofnyrus.block.hivecreep.BlockHivecreepPillar;
import com.vetpetmon.wyrmsofnyrus.block.hivecreep.creepStaged;
import com.vetpetmon.wyrmsofnyrus.block.hivecreep.creepStagedGrass;
import com.vetpetmon.wyrmsofnyrus.compat.SRP;
import com.vetpetmon.wyrmsofnyrus.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.config.WorldConfig;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityBiter;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCrawler;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreeped;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreepedHumanoid;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreepling;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityMinos;
import com.vetpetmon.wyrmsofnyrus.invasion.HiveCreepSpreadFurther;
import com.vetpetmon.wyrmsofnyrus.locallib.DifficultyStats;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CreepedEvents {
    public static void newConvertEvent(Entity entityKilled, Entity sourceEntity) {
        String nameOfMob;
        World world = entityKilled.field_70170_p;
        List entList = world.field_72996_f;
        int count = 0;
        for (int i = 0; i < entList.size(); ++i) {
            if (!(entList.get(i) instanceof EntityCreeped) || ++count <= WorldConfig.aggressiveCreepedCap) continue;
            return;
        }
        boolean override = false;
        String[] cnvList = Invasion.creepConvertList;
        String[] conversion = new String[2];
        if (world.field_72995_K) {
            return;
        }
        try {
            nameOfMob = String.valueOf(EntityList.func_191301_a((Entity)entityKilled));
        }
        catch (Exception nameFail) {
            WyrmsOfNyrus.logger.error("There was a problem when trying to match mob names: ", (Throwable)nameFail);
            return;
        }
        for (String s : cnvList) {
            conversion = s.split(";");
            try {
                if (conversion[0] == null || conversion[1] == null) {
                    return;
                }
            }
            catch (Exception error) {
                WyrmsOfNyrus.logger.error("Failed to convert an entity, more details: ", (Throwable)error);
                return;
            }
            if (!conversion[0].equalsIgnoreCase(nameOfMob)) continue;
            Entity convertToThis = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(conversion[1]), (World)world);
            if (convertToThis == null) {
                return;
            }
            convertToThis.func_82149_j(entityKilled);
            if (entityKilled.func_145818_k_() && Invasion.creepConversionKeepNametag) {
                convertToThis.func_96094_a(entityKilled.func_95999_t());
                convertToThis.func_174805_g(entityKilled.func_174833_aM());
            }
            world.func_72900_e(entityKilled);
            world.func_180498_a(null, 1026, new BlockPos(convertToThis), 0);
            world.func_72838_d(convertToThis);
            DifficultyStats.applyPotionEffect(convertToThis, MobEffects.field_76437_t, 3, 2);
            override = true;
            break;
        }
        if (!override) {
            CreepedEvents.convertKill(entityKilled, sourceEntity);
        }
        CreepedEvents.creepBlockBelow(sourceEntity);
    }

    public static void convertKill(Entity entityKilled, Entity sourceEntity) {
        World world = sourceEntity.field_70170_p;
        EntityCreeped entityToSpawn = null;
        if (entityKilled instanceof EntityLivingBase) {
            EntityLivingBase killedEntity = (EntityLivingBase)entityKilled;
            entityToSpawn = killedEntity instanceof EntityCow ? new EntityMinos(sourceEntity.field_70170_p) : (killedEntity instanceof EntityAnimal ? new EntityBiter(sourceEntity.field_70170_p) : (killedEntity.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD ? new EntityCrawler(sourceEntity.field_70170_p) : (killedEntity instanceof EntityZombie || entityKilled instanceof EntityPlayer || entityKilled instanceof EntityVillager || entityKilled instanceof EntityWitch ? new EntityCreepedHumanoid(world) : new EntityCreepling(world))));
        }
        world.func_72900_e(entityKilled);
        if (entityToSpawn != null) {
            entityToSpawn.func_82149_j(entityKilled);
            if (entityKilled.func_145818_k_() && Invasion.creepConversionKeepNametag) {
                entityToSpawn.func_96094_a(entityKilled.func_95999_t());
                entityToSpawn.func_174805_g(entityKilled.func_174833_aM());
            }
            world.func_180498_a(null, 1026, new BlockPos(sourceEntity), 0);
            world.func_72838_d((Entity)entityToSpawn);
            DifficultyStats.applyPotionEffect((Entity)entityToSpawn, MobEffects.field_76437_t, 3, 2);
        }
    }

    public static void creepBlockBelow(Entity sourceEntity) {
        if (Invasion.isCreepEnabled()) {
            World world = sourceEntity.field_70170_p;
            BlockPos lookingBlock = new BlockPos(sourceEntity.field_70165_t, sourceEntity.field_70163_u - 1.0, sourceEntity.field_70161_v);
            Block blockLooking = world.func_180495_p(lookingBlock).func_177230_c();
            if (HiveCreepSpreadFurther.creepspreadRules(lookingBlock, world, lookingBlock)) {
                assert (false);
                if (SRP.isEnabled() && WorldConfig.vileEnabled) {
                    if (SRP.srpBlocks.contains(blockLooking)) {
                        world.func_180501_a(lookingBlock, AllBlocks.corium.func_176223_P(), 3);
                    }
                    HiveCreepSpreadFurther.addPoints(world);
                }
                if (blockLooking == Block.func_149684_b((String)"minecraft:glowstone")) {
                    world.func_180501_a(lookingBlock, AllBlocks.wyrm_lights_yellow.func_176223_P(), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                } else if (blockLooking instanceof BlockLog || blockLooking == Block.func_149684_b((String)"minecraft:log") || blockLooking instanceof BlockOldLog) {
                    world.func_180501_a(lookingBlock, AllBlocks.creeplog.func_176223_P().func_177226_a((IProperty)BlockHivecreepPillar.ACTIVE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                } else if (HiveCreepSpreadFurther.matLookingBlock(lookingBlock, Material.field_151576_e, world)) {
                    world.func_180501_a(lookingBlock, AllBlocks.creepedstone.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                } else if (HiveCreepSpreadFurther.matLookingBlock(lookingBlock, Material.field_151578_c, world)) {
                    world.func_180501_a(lookingBlock, AllBlocks.creepeddirt.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                } else if (HiveCreepSpreadFurther.matLookingBlock(lookingBlock, Material.field_151595_p, world)) {
                    world.func_180501_a(lookingBlock, AllBlocks.creepedsand.func_176223_P().func_177226_a((IProperty)creepStaged.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                } else if (HiveCreepSpreadFurther.matLookingBlock(lookingBlock, Material.field_151577_b, world)) {
                    world.func_180501_a(lookingBlock, AllBlocks.creepedgrass.func_176223_P().func_177226_a((IProperty)creepStagedGrass.STAGE, (Comparable)Integer.valueOf(0)), 3);
                    HiveCreepSpreadFurther.addPoints(world);
                }
            }
        }
    }
}

