/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ability;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.Constants;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityFungallid;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityRadiwyrm;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmProber;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmRover;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmSoldier;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmWarrior;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmling;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DroppodContents {
    private static void dropPodContents(BlockPos pos, int size, int type, World world) {
        if (!world.field_72995_K) {
            switch (type) {
                case 5: {
                    int i;
                    for (i = 0; i < RNG.getIntRangeInclu((int)1, (int)(2 + size)); ++i) {
                        DroppodContents.spawnMob(pos, new EntityWyrmWarrior(world), world);
                    }
                    for (i = 0; i < RNG.getIntRangeInclu((int)0, (int)(1 + size)); ++i) {
                        DroppodContents.spawnMob(pos, new EntityRadiwyrm(world), world);
                    }
                    break;
                }
                case 4: {
                    if (WoNVars.worldVariables.getInvasionLevel(world) > 1) {
                        for (int i = 0; i < RNG.getIntRangeInclu((int)Invasion.minWyrmsCallouspod, (int)(Invasion.maxWyrmsCallouspod + size)); ++i) {
                            DroppodContents.spawnMob(pos, new EntityRadiwyrm(world), world);
                        }
                    } else {
                        for (int i = 0; i < RNG.getIntRangeInclu((int)Invasion.minWyrmsCallouspod, (int)(Invasion.maxWyrmsCallouspod + size)); ++i) {
                            DroppodContents.spawnMob(pos, new EntityWyrmProber(world), world);
                        }
                    }
                    break;
                }
                case 3: {
                    int m = RNG.getIntRangeInclu((int)0, (int)size);
                    for (int i = 0; i < m; ++i) {
                        DroppodContents.spawnMob(pos, new EntityFungallid(world), world);
                    }
                    break;
                }
                case 2: {
                    int i;
                    int m = RNG.getIntRangeInclu((int)Invasion.minWyrmsCallouspod, (int)(Invasion.maxWyrmsCallouspod + size));
                    for (i = 0; i < m; ++i) {
                        DroppodContents.spawnMob(pos, new EntityWyrmRover(world), world);
                    }
                    m = RNG.getIntRangeInclu((int)((int)Math.floor((double)(Invasion.minWyrmsCallouspod + size) / 2.0)), (int)((int)Math.floor((double)(Invasion.maxWyrmsCallouspod + size) / 2.0)));
                    for (i = 0; i < m; ++i) {
                        DroppodContents.spawnMob(pos, new EntityWyrmSoldier(world), world);
                    }
                    break;
                }
                default: {
                    int m = RNG.getIntRangeInclu((int)Invasion.minWyrmsHexepod, (int)(Invasion.maxWyrmsHexepod + size));
                    for (int i = 0; i < m; ++i) {
                        DroppodContents.spawnMob(pos, new EntityWyrmling(world), world);
                    }
                }
            }
        }
    }

    private static void spawnMob(BlockPos pos, EntityWyrm type, World world) {
        int lvl = WoNVars.worldVariables.getInvasionLevel(world);
        if (RNG.getIntRangeInclu((int)1, (int)Constants.variantChancePerLevel[lvl]) != 1) {
            type.setVariant(RNG.getIntRange((int)0, (int)type.getLegalVariantsLength()));
        }
        type.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)type);
    }

    public static void DropPodEventSequence(BlockPos pos, int size, int type, World world) {
        if (!world.field_72995_K && Radiogenetics.explodingDropPods) {
            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)((double)size * 0.85), true);
        }
        DroppodContents.dropPodContents(pos, size, type, world);
    }
}

