/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ai;

import com.vetpetmon.synlib.core.util.Vect3D;
import com.vetpetmon.wyrmsofnyrus.block.BlockMaterials;
import com.vetpetmon.wyrmsofnyrus.entity.IEntityConfigurable;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmGrunt;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityWyrmWorker;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionPoints;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityAIHarvester
extends EntityAIBase {
    EntityLivingBase target;
    EntityLiving digger;
    int[] positionToMark;
    int tickHarvest;
    int tickScan;
    int scanDelay;
    int scan;
    int tickDown;
    int dist;
    int breakRange;
    ArrayList<Block> blockBlacklist;

    public EntityAIHarvester(EntityLiving ent, int delay, int distance, int breakRange, ArrayList<Block> blacklist) {
        this.digger = ent;
        this.scanDelay = delay;
        this.dist = distance;
        this.breakRange = breakRange;
        this.blockBlacklist = blacklist;
    }

    @Deprecated
    public EntityAIHarvester(EntityLiving ent, int delay, int distance) {
        this.digger = ent;
        this.scanDelay = delay;
        this.dist = distance;
        this.breakRange = 1;
    }

    public boolean func_75250_a() {
        this.target = this.digger.func_70638_az();
        if (this.digger instanceof EntityWyrmWorker) {
            EntityWyrmWorker wyrm = (EntityWyrmWorker)this.digger;
            RayTraceResult ray = this.getSurroundings(this.digger, this.dist);
            if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK || wyrm.getCurrentTask() != EntityWyrmWorker.Task.TUNNEL || !wyrm.getMatrix().getToggle(MobStatConfigs.ToggleConfigs.CANBREAKBLOCKS)) {
                wyrm.setAttack(0);
                return false;
            }
            IBlockState b = this.digger.field_70170_p.func_180495_p(ray.func_178782_a());
            double hLvl = b.func_185887_b(this.digger.field_70170_p, ray.func_178782_a());
            if (hLvl >= 0.0 && hLvl < (double)wyrm.getMatrix().getStat(StatType.BREAKSTRENGTH)) {
                this.positionToMark = new int[]{ray.func_178782_a().func_177958_n(), ray.func_178782_a().func_177956_o(), ray.func_178782_a().func_177952_p()};
                wyrm.setAttack(11);
                return true;
            }
        } else if (this.digger instanceof EntityWyrmGrunt) {
            EntityWyrmGrunt wyrm = (EntityWyrmGrunt)this.digger;
            RayTraceResult ray = this.getSurroundings(this.digger, this.dist);
            if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK || wyrm.getCurrentTask() != EntityWyrmGrunt.Task.TUNNEL || !wyrm.getMatrix().getToggle(MobStatConfigs.ToggleConfigs.CANBREAKBLOCKS)) {
                wyrm.setAttack(0);
                return false;
            }
            IBlockState b = this.digger.field_70170_p.func_180495_p(ray.func_178782_a());
            double hLvl = b.func_185887_b(this.digger.field_70170_p, ray.func_178782_a());
            if (hLvl >= 0.0 && hLvl < (double)wyrm.getMatrix().getStat(StatType.BREAKSTRENGTH)) {
                this.positionToMark = new int[]{ray.func_178782_a().func_177958_n(), ray.func_178782_a().func_177956_o(), ray.func_178782_a().func_177952_p()};
                wyrm.setAttack(11);
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.positionToMark != null && this.digger != null) {
            Vect3D vector = Vect3D.createVector((double)((double)this.positionToMark[0] - this.digger.field_70165_t), (double)((double)this.positionToMark[1] - this.digger.field_70163_u + (double)this.digger.func_70047_e()), (double)((double)this.positionToMark[2] - this.digger.field_70161_v));
            return this.digger.func_70089_S() && vector.length() <= 4.0;
        }
        return false;
    }

    public void func_75246_d() {
        RayTraceResult ray = null;
        if (this.digger.field_70173_aa % this.scanDelay == 0) {
            ray = this.getSurroundings(this.digger, this.dist);
        }
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.positionToMark = new int[]{ray.func_178782_a().func_177958_n(), ray.func_178782_a().func_177956_o(), ray.func_178782_a().func_177952_p()};
        }
        BlockPos pos = new BlockPos(this.positionToMark[0], this.positionToMark[1], this.positionToMark[2]);
        if (this.positionToMark == null || this.blockBlacklist.contains(this.digger.field_70170_p.func_180495_p(pos).func_177230_c()) || this.positionToMark.length != 3 || this.digger.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || pos.equals((Object)this.digger.func_180425_c().func_177977_b()) && this.tickDown > 0) {
            this.tickHarvest = 0;
        } else {
            if (pos.func_177956_o() < this.digger.func_180425_c().func_177956_o() && this.tickDown <= 0) {
                this.tickDown = this.scanDelay * 2;
            } else if (pos.func_177956_o() < this.digger.func_180425_c().func_177956_o()) {
                return;
            }
            --this.tickDown;
            IBlockState block = this.digger.field_70170_p.func_180495_p(pos);
            ++this.tickHarvest;
            int hardness = (int)(block.func_185887_b(this.digger.field_70170_p, pos) / 2.0f);
            if (hardness < 0 || block.func_185904_a() == BlockMaterials.CREEP || block.func_185904_a() == BlockMaterials.WYRM) {
                this.positionToMark = null;
                return;
            }
            float f1 = (float)this.tickHarvest * 0.025f / (float)hardness;
            if (f1 >= 1.0f) {
                this.tickHarvest = 0;
                int reward = Math.max((int)(block.func_185887_b(this.digger.field_70170_p, pos) + 1.0f), 1);
                this.digger.field_70170_p.func_175655_b(pos, false);
                double breakS = 0.5;
                if (this.digger instanceof IEntityConfigurable) {
                    breakS = ((IEntityConfigurable)this.digger).getBreakStrength() * 0.5f;
                }
                for (int i = -this.breakRange + pos.func_177958_n(); i < pos.func_177958_n() + this.breakRange + 1; ++i) {
                    for (int y = pos.func_177956_o(); y < pos.func_177956_o() + this.breakRange + 2; ++y) {
                        for (int z = -this.breakRange + pos.func_177952_p(); z < pos.func_177952_p() + this.breakRange + 1; ++z) {
                            IBlockState block2 = this.digger.field_70170_p.func_180495_p(new BlockPos(i, y, z));
                            double extraH = block2.func_185887_b(this.digger.field_70170_p, new BlockPos(i, y, z)) * 2.0f;
                            if (!(extraH < breakS) || !(extraH > 0.0) || block2.func_185904_a() == BlockMaterials.CREEP || block2.func_185904_a() == BlockMaterials.WYRM) continue;
                            int reward2 = Math.max((int)(block.func_185887_b(this.digger.field_70170_p, pos) + 1.0f), 1);
                            InvasionPoints.addResources(this.digger.field_70170_p, reward2);
                            this.digger.field_70170_p.func_175655_b(new BlockPos(i, y, z), false);
                        }
                    }
                }
                this.positionToMark = null;
                InvasionPoints.addResources(this.digger.field_70170_p, reward);
                if (this.target != null) {
                    this.digger.func_70661_as().func_75484_a(this.digger.func_70661_as().func_75494_a((Entity)this.target), 1.0);
                }
            } else if (this.tickHarvest % (this.scanDelay / 2) == 0) {
                SoundType s = block.func_177230_c().getSoundType(block, this.digger.field_70170_p, pos, (Entity)this.digger);
                this.digger.field_70170_p.func_184133_a(null, this.digger.func_180425_c(), s.func_185845_c(), SoundCategory.BLOCKS, s.field_185860_m + 1.0f, s.field_185861_n);
                this.digger.field_70170_p.func_175715_c(this.digger.func_145782_y(), pos, (int)(f1 * 5.0f));
                InvasionPoints.addResources(this.digger.field_70170_p, 1);
            }
        }
    }

    public void func_75251_c() {
        this.positionToMark = null;
        this.tickHarvest = 0;
    }

    private RayTraceResult getSurroundings(EntityLiving ent, int distance) {
        int z;
        int y;
        float[] yawPitch = new float[]{ent.field_70127_C + (ent.field_70125_A - ent.field_70127_C), ent.field_70126_B + (ent.field_70177_z - ent.field_70126_B)};
        int width = MathHelper.func_76123_f((float)ent.field_70130_N);
        int height = MathHelper.func_76123_f((float)ent.field_70131_O);
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        int thresh = (int)(Math.sqrt(width) * (double)height);
        int x = (int)((double)this.scan % Math.sqrt(width) / (double)width - (double)width / 2.0);
        double[] ray = new double[]{(double)x + ent.field_70165_t, (double)(y = (int)((double)this.scan / Math.sqrt(width))) + ent.field_70163_u + 0.5, (double)(z = (int)((double)this.scan % Math.sqrt(width) / (double)width - (double)width / 2.0)) + ent.field_70161_v};
        RayTraceResult rayCast = this.castRay(ent.field_70170_p, ray, yawPitch, distance);
        if (rayCast != null && rayCast.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.scan = 0;
            return rayCast;
        }
        this.scan = (this.scan + 1) % thresh;
        return null;
    }

    private RayTraceResult castRay(World w, double[] coords, float[] yawPitch, double distance) {
        Vect3D vector = Vect3D.createVector((double)coords[0], (double)coords[1], (double)coords[2]);
        float f0 = 0.01745329f;
        float pi = 3.14f;
        float f1 = MathHelper.func_76134_b((float)(-yawPitch[1] * f0 - pi));
        float f2 = MathHelper.func_76126_a((float)(-yawPitch[1] * f0 - pi));
        float f3 = -MathHelper.func_76134_b((float)(-yawPitch[0] * f0));
        float f4 = MathHelper.func_76126_a((float)(-yawPitch[1] * f0));
        float dist = (float)(distance * (double)1.2f);
        Vect3D vector2 = Vect3D.createVector((double)(coords[0] + (double)(f2 * f3 * dist)), (double)(coords[1] + (double)(f4 * dist)), (double)(coords[2] + (double)(f1 * f3 * dist)));
        return w.func_147447_a(vector.convertToMC3d(), vector2.convertToMC3d(), false, true, false);
    }
}

