/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAITargetJudger<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final EntityAINearestAttackableTarget.Sorter sorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public EntityAITargetJudger(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAITargetJudger(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAITargetJudger(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = entity -> {
            if (entity == null) {
                return false;
            }
            if (targetSelector != null && !targetSelector.apply(entity)) {
                return false;
            }
            return EntitySelectors.field_180132_d.apply(entity) && this.func_75296_a((EntityLivingBase)entity, false);
        };
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            list.sort(this.sorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

            @Nullable
            public Double apply(@Nullable EntityPlayer player) {
                double chance = 1.0;
                if (player == null) {
                    return chance;
                }
                if (player.func_70658_aO() > 0) {
                    chance = 0.05;
                    if ((double)player.func_110143_aJ() <= (double)player.func_110138_aP() * 0.75) {
                        chance = 1.0;
                    }
                }
                ItemStack itemstack = player.func_184582_a(EntityEquipmentSlot.FEET);
                if (player.func_70644_a(MobEffects.field_188423_x) || player.func_70051_ag()) {
                    return chance;
                }
                if (itemstack.func_77973_b() == Items.field_151021_T) {
                    chance *= 0.8;
                }
                if (player.func_70093_af()) {
                    chance *= 0.7;
                }
                if (player.func_70644_a(MobEffects.field_76441_p)) {
                    chance /= 2.0;
                }
                if (player.func_130014_f_().func_175699_k(player.func_180425_c()) < 8) {
                    chance /= 2.0;
                }
                return chance;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity ent1, Entity ent2) {
            double d1;
            double d0 = this.entity.func_70068_e(ent1);
            if (d0 < (d1 = this.entity.func_70068_e(ent2))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

