/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ai.gestalt;

import com.google.common.base.Predicate;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.entity.ai.gestalt.GestaltHostMind;
import com.vetpetmon.wyrmsofnyrus.handlers.WoNHandler;
import com.vetpetmon.wyrmsofnyrus.locallib.util.Vect3D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class GestaltFollow<T extends EntityLivingBase>
extends EntityAITarget {
    private EntityLivingBase target;
    protected final Class<T> targetClass;
    private final EntityLiving host;
    private final Sorter targetSorter;
    private final int range;
    private final int distance;
    private static final int vert = 10;
    private final double speed;
    protected final Predicate targetEntitySelector;
    protected T targetEntity;

    public GestaltFollow(EntityCreature host, Class target, double speedIn, int range, int distance) {
        super(host, false, false);
        this.targetClass = target;
        this.host = host;
        this.speed = speedIn;
        this.range = range;
        this.distance = distance;
        this.targetSorter = new Sorter((Entity)host);
        this.targetEntitySelector = null;
    }

    public GestaltFollow(EntityCreature host, Class target, double speedIn, int range, int distance, final @Nullable Predicate<? super T> targetSelector) {
        super(host, false, false);
        this.targetClass = target;
        this.host = host;
        this.speed = speedIn;
        this.range = range;
        this.distance = distance;
        this.targetSorter = new Sorter((Entity)host);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                if (targetSelector != null && !targetSelector.apply(p_apply_1_)) {
                    return false;
                }
                return EntitySelectors.field_180132_d.apply(p_apply_1_) && GestaltFollow.this.func_75296_a(p_apply_1_, false);
            }
        };
    }

    public boolean func_75250_a() {
        if (AI.gestaltUseInfamy) {
            if (this.host.func_70681_au().nextInt(110) < GestaltHostMind.getAttentionLevel(this.host.func_130014_f_()) && this.host.func_70638_az() == null) {
                this.findTarget();
                return this.target != null;
            }
        } else if (this.host.func_70681_au().nextInt(110) < 5 && this.host.func_70638_az() == null) {
            this.findTarget();
            return this.target != null;
        }
        if (GestaltHostMind.getLastKnownPos() != null && this.host.field_70170_p.func_175667_e(GestaltHostMind.getLastKnownPos())) {
            this.host.func_70661_as().func_75492_a((double)GestaltHostMind.getLastKnownPos().func_177958_n(), (double)GestaltHostMind.getLastKnownPos().func_177956_o(), (double)GestaltHostMind.getLastKnownPos().func_177952_p(), this.speed);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.field_75299_d.func_70638_az() == null) {
            return false;
        }
        EntityLivingBase target = this.field_75299_d.func_70638_az();
        if (!target.func_70089_S()) {
            if (GestaltHostMind.getAttentionLevel(this.field_75299_d.field_70170_p) == 100 && target.func_70005_c_().equals(GestaltHostMind.getKollectiveTarget().func_70005_c_())) {
                GestaltHostMind.infamyIsMaxed = false;
                WoNHandler.infamyDecay = 5;
                GestaltHostMind.setAttentionLevel(1, this.field_75299_d.field_70170_p);
                GestaltHostMind.setKollectiveTarget(null);
                GestaltHostMind.setLastKnownPos(null);
            }
            return false;
        }
        if (this.host.func_70661_as().func_75500_f()) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75249_e() {
        super.func_75249_e();
        if (this.host.func_70638_az() != null) {
            Vect3D v = Vect3D.createVector(this.target.field_70165_t - this.host.field_70165_t, this.target.field_70163_u - this.host.field_70163_u, this.target.field_70161_v - this.host.field_70161_v);
            int range = this.distance;
            if (GestaltHostMind.getAttentionLevel(this.host.field_70170_p) > 50) {
                range *= 2;
            }
            if (AI.maxInfamyTotalWar && GestaltHostMind.infamyIsMaxed && v.length() < AI.gestaltTotalAwarenessRange * 8.0) {
                this.host.func_70624_b(this.target);
            } else if (AI.gestaltTotalAwareness) {
                if (AI.gestaltUseInfamy && v.length() < AI.gestaltTotalAwarenessRange * ((double)GestaltHostMind.getAttentionLevel(this.host.field_70170_p) * AI.gestaltTARMod)) {
                    this.host.func_70624_b(this.target);
                } else if (v.length() < AI.gestaltTotalAwarenessRange) {
                    this.host.func_70624_b(this.target);
                }
            }
            v = v.normalize();
            v.x *= (double)range;
            v.y *= (double)range;
            v.z *= (double)range;
            double x = this.host.field_70165_t + v.x;
            double y = this.host.field_70163_u + v.y - 5.0 + (double)this.host.func_70681_au().nextInt(11);
            double z = this.host.field_70161_v + v.z;
            this.host.func_70661_as().func_75492_a(x, y, z, this.speed);
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.target = null;
    }

    private AxisAlignedBB getDetectionRange() {
        int multiplier = 1;
        if (AI.maxInfamyTotalWar && GestaltHostMind.infamyIsMaxed) {
            multiplier = 2;
        }
        return new AxisAlignedBB(this.host.field_70165_t - (double)(this.range * multiplier), this.host.field_70163_u - (double)(10 * multiplier), this.host.field_70161_v - (double)(this.range * multiplier), this.host.field_70165_t + (double)(this.range * multiplier), this.host.field_70163_u + (double)(10 * multiplier), this.host.field_70161_v + (double)(this.range * multiplier));
    }

    private void findTarget() {
        List list = this.host.field_70170_p.func_175647_a(this.targetClass, this.getDetectionRange(), this.targetEntitySelector);
        Collections.sort(list, this.targetSorter);
        if (!list.isEmpty()) {
            this.target = (EntityLivingBase)list.get(0);
        }
    }

    public static class Sorter
    implements Comparator {
        private final Entity host;

        public Sorter(Entity hostEnt) {
            this.host = hostEnt;
        }

        public int compare(Entity firstEntity, Entity secondEntity) {
            return Double.compare(this.host.func_70068_e(firstEntity), this.host.func_70068_e(secondEntity));
        }

        public int compare(Object firstEntity, Object secondEntity) {
            return this.compare((Entity)firstEntity, (Entity)secondEntity);
        }
    }
}

