/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.ai.gestalt;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.handlers.WoNHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GestaltHostMind {
    private static EntityLivingBase kollectiveTarget;
    private static BlockPos lastKnownPos;
    public static int memoryTimer;
    public static boolean isGestaltActive;
    public static boolean infamyIsMaxed;

    public static EntityLivingBase getKollectiveTarget() {
        return kollectiveTarget;
    }

    private static void resetMemoryTimer() {
        memoryTimer = AI.gestaltMemLimit * 20;
    }

    public static void setLastKnownPos(BlockPos lastKnownPos) {
        GestaltHostMind.lastKnownPos = lastKnownPos;
    }

    public static BlockPos getLastKnownPos() {
        if (GestaltHostMind.getKollectiveTarget() != null) {
            lastKnownPos = GestaltHostMind.getKollectiveTarget().func_180425_c();
        }
        return lastKnownPos;
    }

    public static int getAttentionLevel(World world) {
        int infamy = WoNVars.worldVariables.get((World)world).infamy;
        if (WoNVars.worldVariables.get((World)world).infamy == 100 && !infamyIsMaxed) {
            infamyIsMaxed = true;
        }
        return infamy;
    }

    public static void setAttentionLevel(int attentionLevel, World world) {
        WoNVars.worldVariables.get((World)world).infamy = attentionLevel;
        WoNVars.worldVariables.get(world).syncData(world);
    }

    public static void increaseAttentionLevel(World world) {
        if (!isGestaltActive) {
            isGestaltActive = true;
        }
        if (WoNVars.worldVariables.get((World)world).infamy < 100) {
            ++WoNVars.worldVariables.get((World)world).infamy;
        }
        if (WoNVars.worldVariables.get((World)world).infamy == 100 && !world.field_73010_i.isEmpty() && !infamyIsMaxed) {
            for (EntityPlayer player : world.field_73010_i) {
                if (!player.func_70005_c_().equals(GestaltHostMind.getKollectiveTarget().func_70005_c_())) continue;
                world.func_184133_a(null, GestaltHostMind.getLastKnownPos(), SoundRegistry.maxinfamy, SoundCategory.HOSTILE, 4.0f, 1.0f);
            }
            infamyIsMaxed = true;
        }
        WoNVars.worldVariables.get(world).syncData(world);
    }

    public static void decreaseAttentionLevel(World world) {
        if (GestaltHostMind.getAttentionLevel(world) > 0) {
            --WoNVars.worldVariables.get((World)world).infamy;
        }
        if (GestaltHostMind.getAttentionLevel(world) < 100 && infamyIsMaxed) {
            infamyIsMaxed = false;
            WoNHandler.infamyDecay = 5;
        }
        WoNVars.worldVariables.get(world).syncData(world);
    }

    public static void setKollectiveTarget(@Nullable EntityLivingBase target) {
        if (infamyIsMaxed && GestaltHostMind.getKollectiveTarget() != target) {
            WoNHandler.infamyDecay = 5;
            infamyIsMaxed = true;
        }
        kollectiveTarget = target;
        GestaltHostMind.resetMemoryTimer();
    }

    public static void runMemory() {
        if (kollectiveTarget != null && !infamyIsMaxed && --memoryTimer <= 0) {
            GestaltHostMind.forget();
        }
    }

    public static void forget() {
        WyrmsOfNyrus.logger.debug("The hive has decided to forget their previous target, " + GestaltHostMind.getKollectiveTarget().func_70005_c_() + ".");
        GestaltHostMind.resetMemoryTimer();
        GestaltHostMind.setKollectiveTarget(null);
        lastKnownPos = null;
    }

    static {
        memoryTimer = AI.gestaltMemLimit * 20;
        isGestaltActive = false;
        infamyIsMaxed = false;
    }
}

