/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.creeped;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreeped;
import com.vetpetmon.wyrmsofnyrus.handlers.LootTables;
import com.vetpetmon.wyrmsofnyrus.locallib.DifficultyStats;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityCrawler
extends EntityCreeped {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityCrawler.class, (DataSerializer)DataSerializers.field_187191_a);

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.crawlerStatMatrix;
    }

    public EntityCrawler(World worldIn) {
        super(worldIn);
        this.casteType = 0;
        this.func_70105_a(0.65f, 0.68f);
        this.field_70728_aV = 5;
        this.func_94061_f(false);
        this.setPotency(8.0);
        this.withID(this, 17);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.CRAWLER_LOOT_TABLE;
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.biter;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public Byte getClimbing() {
        return (Byte)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.creepedAfterPlayers(true);
        this.afterAnimals();
        this.afterVillagers();
        this.afterMobs();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.6f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AICrawlerAttack(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if ((Byte)this.field_70180_af.func_187225_a(CLIMBING) != 0) {
                this.field_70181_x = 0.75;
            }
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            DifficultyStats.applyPotionEffect(entityIn, MobEffects.field_76436_u, 20, this.getEffectLevel(), true);
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    static class AICrawlerAttack
    extends EntityAIAttackMelee {
        public AICrawlerAttack(EntityCrawler spider) {
            super((EntityCreature)spider, 1.5, true);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

