/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.variant;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.Constants;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.Radiogenetics;
import com.vetpetmon.wyrmsofnyrus.entity.MobEntityBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class WyrmVariant {
    private float[] stats;
    private float[] baseModifiers = new float[]{0.5f, 0.25f, 0.25f};
    private int totalSpentPoints;
    protected int[] spentPoints = new int[]{0, 0, 0};
    private File genomeFile = new File("/genomes", "/genome_" + this.getID() + ".genesis");
    private int pressureScore = 0;
    private int ID;
    private int lootID = 0;

    public int getMaxMutationModifer() {
        return 100;
    }

    public int getPressureScore() {
        return this.pressureScore;
    }

    public void setPressureScore(int pressureScore) {
        this.pressureScore = pressureScore;
    }

    public void resetPressureScore() {
        this.pressureScore = 0;
    }

    public void addPressureScore() {
        ++this.pressureScore;
    }

    public int calculatePointsSpent() {
        this.totalSpentPoints = 0;
        for (int i : this.spentPoints) {
            this.totalSpentPoints += i;
        }
        return this.totalSpentPoints;
    }

    public void setBaseModifiers(float[] mods) {
        this.baseModifiers = mods;
    }

    public boolean canMutate() {
        return Radiogenetics.natSelection && this.calculatePointsSpent() < this.getMaxMutationModifer();
    }

    public boolean needsToMutate() {
        return this.calculatePointsSpent() > 0;
    }

    public void addModPoint(int statID, World world) {
        if (this.canMutate()) {
            switch (statID) {
                case 1: {
                    this.spentPoints[1] = this.spentPoints[1] + 1;
                    break;
                }
                case 2: {
                    this.spentPoints[2] = this.spentPoints[2] + 1;
                    break;
                }
                default: {
                    this.spentPoints[0] = this.spentPoints[0] + 1;
                }
            }
        }
        this.saveMutationFile(world);
    }

    public void removeModPoint(int statID, World world) {
        if (!this.needsToMutate()) {
            switch (statID) {
                case 1: {
                    if (this.spentPoints[1] <= 0) break;
                    this.spentPoints[1] = this.spentPoints[1] - 1;
                    break;
                }
                case 2: {
                    if (this.spentPoints[2] <= 0) break;
                    this.spentPoints[2] = this.spentPoints[2] - 1;
                    break;
                }
                default: {
                    if (this.spentPoints[2] <= 0) break;
                    this.spentPoints[0] = this.spentPoints[0] - 1;
                }
            }
        }
        this.saveMutationFile(world);
    }

    public void mutate(World world) {
        this.loadMutationFile(world);
        int rng1 = RNG.getIntRangeInclu((int)1, (int)2);
        int rng2 = RNG.getIntRangeInclu((int)0, (int)2);
        if (!this.canMutate()) {
            this.removeModPoint(rng1, world);
        } else if (rng2 == 1) {
            this.removeModPoint(rng1, world);
        } else {
            this.addModPoint(rng1, world);
        }
    }

    public float getStatWithMod(int statID) {
        int i;
        switch (statID) {
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
                break;
            }
            default: {
                i = 0;
            }
        }
        float totalMod = (float)this.spentPoints[i] * this.baseModifiers[i];
        return totalMod;
    }

    public float[] getModifiedStats(boolean withReCalc, World world) {
        if (withReCalc) {
            this.stats = new float[]{this.getStatWithMod(0), this.getStatWithMod(1), this.getStatWithMod(2)};
        }
        return this.stats;
    }

    public void loadMutationFile(World world) {
        File dir = world.func_72860_G().func_75765_b();
        try {
            File geneData = new File(dir.getPath() + "/genomes/genome_" + this.getID() + ".genesis");
            this.readGenome(geneData);
        }
        catch (IOException e) {
            WyrmsOfNyrus.logger.error("An error occurred when reading genome_" + this.getID() + ".genesis");
            e.printStackTrace();
        }
    }

    public void createMutationFile(World world) {
        this.saveMutationFile(world);
    }

    private void saveMutationFile(World world) {
        File dir = world.func_72860_G().func_75765_b();
        try {
            new File(world.func_72860_G().func_75765_b().getPath() + "/genomes").mkdirs();
            File geneData = new File(dir.getPath() + "/genomes/genome_" + this.getID() + ".genesis");
            if (geneData.createNewFile()) {
                WyrmsOfNyrus.logger.info("File created: " + geneData.getName());
                try {
                    BufferedWriter youLostTheGame = this.writeGenome(geneData);
                    youLostTheGame.close();
                }
                catch (IOException e) {
                    WyrmsOfNyrus.logger.error("An error occurred when creating this file with data: " + dir + this.genomeFile);
                    e.printStackTrace();
                }
            } else {
                try {
                    BufferedWriter youLostTheGame = this.writeGenome(geneData);
                    youLostTheGame.close();
                }
                catch (IOException e) {
                    WyrmsOfNyrus.logger.error("An error occurred when writing to " + dir + this.genomeFile);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            WyrmsOfNyrus.logger.error("An error occurred when creating the save file for genome " + this.getID());
            e.printStackTrace();
        }
    }

    protected BufferedWriter writeGenome(File geneData) throws IOException {
        BufferedWriter magicalWizardNonsense = new BufferedWriter(new FileWriter(geneData));
        magicalWizardNonsense.write(this.spentPoints[0] + "\n" + this.spentPoints[1] + "\n" + this.spentPoints[2] + "\n" + this.getPressureScore());
        magicalWizardNonsense.flush();
        return magicalWizardNonsense;
    }

    protected void readGenome(File geneData) throws IOException {
        try {
            BufferedReader interpreter = new BufferedReader(new FileReader(geneData));
            String line = interpreter.readLine();
            int i = 0;
            while (line != null) {
                if (i <= 2) {
                    this.spentPoints[i] = Integer.parseInt(line);
                } else {
                    this.setPressureScore(Integer.parseInt(line));
                }
                line = interpreter.readLine();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public int getID() {
        return this.ID;
    }

    public boolean canFly() {
        return true;
    }

    public void onDeath(MobEntityBase ent) {
    }

    public void onLiving(MobEntityBase ent) {
    }

    public int getLootID() {
        return this.lootID;
    }

    public void setLootID(int id) {
        this.lootID = id;
    }

    public boolean damageImmunity(DamageSource source) {
        return false;
    }

    public void onAttack(Entity entityIn) {
    }

    public void onHit(MobEntityBase ent) {
    }

    public String getVariantName() {
        return Constants.getVariant(this.getID());
    }

    public boolean potionImmunities(PotionEffect potion) {
        return true;
    }

    public float getRenderingOpacity() {
        return 1.0f;
    }

    public boolean hasRadAura() {
        return true;
    }

    public int radAuraStrength() {
        return 1;
    }

    public WyrmVariant(int ID) {
        this.setID(ID);
    }

    public WyrmVariant(int ID, float[] withMods) {
        this.setID(ID);
        this.setBaseModifiers(withMods);
    }
}

