/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.worm;

import com.vetpetmon.wyrmsofnyrus.entity.worm.WormEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class WormBody {
    private WormEntity creature;

    public WormBody(WormEntity entity) {
        this.creature = entity;
    }

    protected void updateMovement() {
        double targetingRange = 328.0;
        if (this.creature.targetedEntity != null && this.creature.targetedEntity.func_70068_e((Entity)this.creature) < targetingRange * targetingRange) {
            this.creature.wayX = this.creature.targetedEntity.field_70165_t;
            this.creature.wayY = this.creature.targetedEntity.field_70163_u;
            this.creature.wayZ = this.creature.targetedEntity.field_70161_v;
        }
        if (!(this.creature.field_70173_aa % 60 != 0 && this.creature.field_70173_aa != 1 || this.creature.targetedEntity != null && this.creature.connection != null)) {
            this.findEntityToFollow(this.creature.field_70170_p.func_175647_a(WormEntity.class, this.creature.func_174813_aQ().func_72314_b(this.creature.partRANGE, this.creature.partRANGE, this.creature.partRANGE), WormEntity.wormSelector));
        }
        double deltaX = this.creature.wayX - this.creature.field_70165_t;
        double deltaY = this.creature.wayY - this.creature.field_70163_u;
        double deltaZ = this.creature.wayZ - this.creature.field_70161_v;
        double deltaDist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        if (this.creature.targetedEntity != null) {
            this.creature.func_70625_a(this.creature.targetedEntity, 180.0f, 180.0f);
        }
        this.creature.bodySPD = Math.max(0.0, Math.min(deltaDist - this.creature.partDIST, this.creature.maxBodySPD));
        if (deltaDist < this.creature.partDIST * 0.895) {
            this.creature.field_70159_w *= 0.8;
            this.creature.field_70181_x *= 0.8;
            this.creature.field_70179_y *= 0.8;
        } else {
            this.creature.field_70159_w = deltaX / deltaDist * this.creature.bodySPD;
            this.creature.field_70181_x = deltaY / deltaDist * this.creature.bodySPD;
            this.creature.field_70179_y = deltaZ / deltaDist * this.creature.bodySPD;
        }
    }

    protected void findEntityToFollow(List<WormEntity> segments) {
        for (WormEntity segment : segments) {
            if (segment.getHeadID() != this.creature.getHeadID()) continue;
            if (segment.isHead()) {
                if (this.creature.getSegmentID() == 0) {
                    this.creature.targetedEntity = segment;
                }
                this.creature.connection = segment;
                continue;
            }
            if (segment.getSegmentID() != this.creature.getSegmentID() - 1) continue;
            this.creature.targetedEntity = segment;
        }
        this.creature.performedCheck = true;
    }
}

