/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.wyrms;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrmFlying;
import com.vetpetmon.wyrmsofnyrus.entity.ability.painandsuffering.BreakGlass;
import com.vetpetmon.wyrmsofnyrus.entity.ai.FlyingMobAI;
import com.vetpetmon.wyrmsofnyrus.entity.ai.ProberAttackAI;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionPoints;
import com.vetpetmon.wyrmsofnyrus.item.AllItems;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityWyrmProber
extends EntityWyrmFlying {
    public static int[] legalVarInts = new int[]{0, 4, 14, 15, 16};
    private int proberTimer;
    private int probingpoints;

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.proberStatMatrix;
    }

    public EntityWyrmProber(World world) {
        super(world);
        this.casteType = 2;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70728_aV = 3;
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
        this.field_70765_h = new WyrmProberMoveHelper(this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.setLegalVariants(legalVarInts);
        this.func_110163_bv();
        this.func_94061_f(false);
        this.proberTimer = 2500;
        this.probingpoints = 0;
        this.setPotency(1.0);
        this.withID(this, 2);
    }

    @Override
    protected boolean canEnrage() {
        return false;
    }

    @Override
    protected boolean partakesInGestalt() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
        if (Invasion.probingEnabled) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMatrix().getStat(StatType.SPEED) + 0.25);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.simpleAI();
        if (Invasion.probingEnabled) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ProberAttackAI((EntityCreature)this, 1.25, true));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new FlyingMobAI(this, 7.75, 256, 10));
            this.afterPlayers(false, true);
            this.afterVillagers();
            this.afterAnimals();
            this.afterMobs();
        } else {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.05, false));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new FlyingMobAI(this, 6.05, 100));
            this.makeAllTargets();
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (Invasion.probingEnabled) {
            this.probingpoints += 5;
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        if (result) {
            this.probingpoints += 2;
        }
        return result;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && --this.proberTimer <= 0) {
            InvasionPoints.add(this.field_70170_p, this.probingpoints);
            this.func_70106_y();
        }
        if (this.field_70171_ac) {
            this.func_70665_d(DamageSource.field_76380_i, 50.0f);
        }
        if (AI.destroyBlocks && Invasion.probingEnabled && this.hasAttackTarget()) {
            BreakGlass.CheckAndBreak(this.field_70170_p, this.func_180425_c(), 1.0, 1.0, this.getBreakStrength(), (Entity)this);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    protected Item func_146068_u() {
        return new ItemStack(AllItems.creepshard, 1).func_77973_b();
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.proberidle;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.bat.takeoff"));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("proberTimer")) {
            this.proberTimer = compound.func_74762_e("proberTimer");
        }
        if (compound.func_74764_b("probingpoints")) {
            this.probingpoints = compound.func_74762_e("probingpoints");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("proberTimer", this.proberTimer);
        compound.func_74768_a("probingpoints", this.probingpoints);
    }

    class WyrmProberMoveHelper
    extends EntityMoveHelper {
        private final EntityWyrmProber parentEntity;
        private double speedW;

        public WyrmProberMoveHelper(EntityWyrmProber WyrmProber) {
            super((EntityLiving)WyrmProber);
            this.parentEntity = WyrmProber;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityWyrmProber.this.field_70165_t;
                double d1 = this.field_75647_c - EntityWyrmProber.this.field_70163_u;
                double d2 = this.field_75644_d - EntityWyrmProber.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityWyrmProber.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityWyrmProber.this.field_70159_w *= 0.5;
                    EntityWyrmProber.this.field_70181_x *= 0.5;
                    EntityWyrmProber.this.field_70179_y *= 0.5;
                } else {
                    EntityWyrmProber.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityWyrmProber.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityWyrmProber.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityWyrmProber.this.func_70638_az() == null) {
                        EntityWyrmProber.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityWyrmProber.this.field_70159_w, (double)EntityWyrmProber.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityWyrmProber.this.func_70638_az().field_70165_t - EntityWyrmProber.this.field_70165_t;
                        double d5 = EntityWyrmProber.this.func_70638_az().field_70161_v - EntityWyrmProber.this.field_70161_v;
                        EntityWyrmProber.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                    EntityWyrmProber.this.field_70761_aq = EntityWyrmProber.this.field_70177_z;
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

