/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.wyrms;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.AI;
import com.vetpetmon.wyrmsofnyrus.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.entity.EntityHitbox;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.ability.painandsuffering.BreakBlocksWithBlacklist;
import com.vetpetmon.wyrmsofnyrus.entity.ai.WideRangeAttackAI;
import com.vetpetmon.wyrmsofnyrus.handlers.LootTables;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWyrmSoldier
extends EntityWyrm {
    public static int[] legalVarInts = new int[]{0, 4, 5, 7, 8, 9, 14, 16, 17, 18, 20, 24};
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityWyrmSoldier.class, (DataSerializer)DataSerializers.field_187191_a);
    public EntityHitbox tail;
    public EntityHitbox tail2;
    public EntityHitbox claw1;
    public EntityHitbox claw2;

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.soldierStatMatrix;
    }

    @Override
    public boolean hasShellFunctionality() {
        return true;
    }

    public EntityWyrmSoldier(World world) {
        super(world);
        this.casteType = 3;
        this.func_70105_a(1.75f, 1.0f);
        this.field_70728_aV = 8;
        this.func_110163_bv();
        this.func_94061_f(false);
        this.setRadAuraRadius(4.0);
        this.setLegalVariants(legalVarInts);
        this.setPotency(15.0);
        this.setShellStatus(true);
        this.setShellHP((int)((double)((int)this.getMatrix().getStat(StatType.HEALTH) + 1) * 0.75));
        this.withID(this, 7);
        this.tail = new EntityHitbox((EntityLiving)this, 1.6f, -1.75f, 0.1f, 1.5f, 1.2f, 0.5f);
        this.tail2 = new EntityHitbox((EntityLiving)this, 1.6f, -3.0f, 0.1f, 1.0f, 1.2f, 0.4f);
        this.claw1 = new EntityHitbox((EntityLiving)this, -0.75f, -1.5f, 0.0f, 0.8f, 1.0f, 1.2f);
        this.claw2 = new EntityHitbox((EntityLiving)this, -2.55f, -1.5f, 0.0f, 0.8f, 1.0f, 1.2f);
        this.hitboxes = new EntityHitbox[]{this.tail, this.tail2, this.claw1, this.claw2};
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.SOLDIER_LOOT_TABLES[this.getVariant().getLootID()];
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new WideRangeAttackAI(this.getMatrix().getStat(StatType.ATTACK), this, 0.5, true, 1.5f, 30));
        this.afterPlayers();
        if (EntityWyrmSoldier.getAttackVillagers()) {
            this.afterVillagers();
        }
        this.afterMobs();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    public void updateHitboxes() {
        float tailOffsetY;
        super.updateHitboxes();
        float f = tailOffsetY = (Byte)this.field_70180_af.func_187225_a(CLIMBING) != 0 ? -1.4f : 0.0f;
        if (this.tail != null) {
            this.tail.func_70634_a(this.tail.field_70165_t, this.tail.field_70163_u + (double)tailOffsetY, this.tail.field_70161_v);
            if ((Byte)this.field_70180_af.func_187225_a(CLIMBING) != 0) {
                this.tail.func_70634_a(this.field_70165_t, this.tail.field_70163_u, this.field_70161_v);
            }
        }
        if (this.tail2 != null) {
            this.tail2.func_70634_a(this.tail2.field_70165_t, this.tail2.field_70163_u + (double)(tailOffsetY * 2.0f), this.tail2.field_70161_v);
            if ((Byte)this.field_70180_af.func_187225_a(CLIMBING) != 0) {
                this.tail2.func_70634_a(this.field_70165_t, this.tail2.field_70163_u, this.field_70161_v);
            }
        }
        if (this.claw1 != null) {
            this.claw1.func_70634_a(this.claw1.field_70165_t, this.claw1.field_70163_u - (double)tailOffsetY, this.claw1.field_70161_v);
        }
        if (this.claw2 != null) {
            this.claw2.func_70634_a(this.claw2.field_70165_t, this.claw2.field_70163_u - (double)tailOffsetY, this.claw2.field_70161_v);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos aboveBlockCentral;
            this.setBesideClimbableBlock(this.field_70123_F);
            if ((Byte)this.field_70180_af.func_187225_a(CLIMBING) != 0) {
                this.field_70181_x = 0.15;
            }
            if (AI.destroyBlocks && !this.hasShell() && !this.field_70170_p.func_175623_d(aboveBlockCentral = new BlockPos(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v))) {
                BreakBlocksWithBlacklist.CheckAndBreak(this.field_70170_p, this.func_180425_c(), 2.0, 4.0, this.getBreakStrength(), (Entity)this, AI.blockDropChance, AI.doBlockDrops, WyrmStats.soldierBreakBLBlocks);
                WyrmsOfNyrus.proxy.ScreamScreenShake(this, 0.75f, 1.0f, false);
            }
        }
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
    }

    protected float func_175134_bD() {
        return 0.6f;
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.deepwyrmclicks;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundRegistry.soldierhurt;
    }

    public SoundEvent func_184615_bR() {
        return SoundRegistry.soldierdeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.slowwyrmsteps, 1.0f, 1.0f);
    }
}

