/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.entity.wyrms;

import com.vetpetmon.wyrmsofnyrus.SoundRegistry;
import com.vetpetmon.wyrmsofnyrus.config.WyrmStats;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.ability.WyrmlingGrowUp;
import com.vetpetmon.wyrmsofnyrus.locallib.MobStatConfigs;
import java.util.HashMap;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityWyrmling
extends EntityWyrm {
    private int timeUntilGrowth;
    private int age;
    private boolean hasGrown;

    @Override
    public MobStatConfigs getMatrix() {
        return WyrmStats.wyrmlingStatMatrix;
    }

    public EntityWyrmling(World world) {
        super(world);
        this.casteType = 0;
        this.hasGrown = false;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70728_aV = 1;
        this.field_70178_ae = false;
        this.func_110163_bv();
        this.func_94061_f(false);
        this.setPotency(1.5);
        this.withID(this, 1);
        this.age = 0;
        this.timeUntilGrowth = this.field_70146_Z.nextInt(6000) + 2000;
    }

    public int getTimeUntilGrowth() {
        return this.age;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 3.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.simpleAI();
    }

    @Override
    protected boolean canEnrage() {
        return false;
    }

    @Override
    protected boolean partakesInGestalt() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setStats(this.getMatrix());
    }

    public SoundEvent func_184639_G() {
        return SoundRegistry.wyrmlingclicks;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundRegistry.wyrmlinghurt;
    }

    public SoundEvent func_184615_bR() {
        return SoundRegistry.wyrmlingdeath;
    }

    @Override
    public void func_70636_d() {
        ++this.age;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && --this.timeUntilGrowth <= 0 && !this.hasGrown) {
            World world = this.field_70170_p;
            int i = (int)this.field_70165_t;
            int j = (int)this.field_70163_u;
            int k = (int)this.field_70161_v;
            HashMap<String, Object> d = new HashMap<String, Object>();
            d.put("x", i);
            d.put("y", j);
            d.put("z", k);
            d.put("world", world);
            WyrmlingGrowUp.growUp(d, this);
            this.hasGrown = true;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timeUntilGrowth = compound.func_74762_e("GrowthTime");
        this.age = compound.func_74762_e("Age");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("GrowthTime", this.timeUntilGrowth);
        compound.func_74768_a("Age", this.age);
    }
}

