/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.invasion;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.invasion.InvasionEvent;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventAirRaid;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventCreepDrop;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventFlashstorm;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventIncursion;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventScouters;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventVisitor;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventWormBoss;
import com.vetpetmon.wyrmsofnyrus.invasion.events.EventWyrmlingDrop;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class InvasionEvents {
    public static ArrayList<InvasionEvent> stage0Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage1Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage2Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage3Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage4Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage5Events = new ArrayList();
    public static ArrayList<InvasionEvent> stage6Events = new ArrayList();

    public static void addEvent(int ID, int stages, int level, int updateFreq, int stageNumber, int poolWeight) {
        InvasionEvent event = InvasionEvents.getEvent(ID);
        if (event == null) {
            WyrmsOfNyrus.logger.error("Tried to call for a event that does not exist");
            return;
        }
        event.setStages(stages);
        event.setLevel(level);
        event.setUpdateFreq(updateFreq);
        block9: for (int i = 0; i < poolWeight; ++i) {
            switch (stageNumber) {
                case 0: {
                    stage0Events.add(event);
                    continue block9;
                }
                case 1: {
                    stage1Events.add(event);
                    continue block9;
                }
                case 2: {
                    stage2Events.add(event);
                    continue block9;
                }
                case 3: {
                    stage3Events.add(event);
                    continue block9;
                }
                case 4: {
                    stage4Events.add(event);
                    continue block9;
                }
                case 5: {
                    stage5Events.add(event);
                    continue block9;
                }
                case 6: {
                    stage6Events.add(event);
                    continue block9;
                }
                default: {
                    WyrmsOfNyrus.logger.error("Tried to add in an event for an invasion phase that does not exist");
                    return;
                }
            }
        }
        WyrmsOfNyrus.logger.debug("Added event of ID " + ID + " to Stage " + stageNumber + "'s event pool with a weight of " + poolWeight);
    }

    @Nullable
    public static InvasionEvent getEvent(int ID) {
        InvasionEvent event = null;
        switch (ID) {
            case 0: {
                event = new EventVisitor();
                break;
            }
            case 1: {
                event = new EventIncursion();
                break;
            }
            case 2: {
                event = new EventScouters();
                break;
            }
            case 3: {
                event = new EventWyrmlingDrop();
                break;
            }
            case 4: {
                event = new EventCreepDrop();
                break;
            }
            case 5: {
                event = new EventWormBoss();
                break;
            }
            case 6: {
                event = new EventAirRaid();
                break;
            }
            case 7: {
                event = new EventFlashstorm();
            }
        }
        return event;
    }

    public static ArrayList<InvasionEvent> getEventPool(int stage) {
        switch (stage) {
            case 1: {
                return stage1Events;
            }
            case 2: {
                return stage2Events;
            }
            case 3: {
                return stage3Events;
            }
            case 4: {
                return stage4Events;
            }
            case 5: {
                return stage5Events;
            }
            case 6: {
                return stage6Events;
            }
        }
        return stage0Events;
    }

    public static InvasionEvent pullEventFromPool(int stage) {
        ArrayList<InvasionEvent> pool = InvasionEvents.getEventPool(stage);
        return pool.get(RNG.getIntRange((int)0, (int)pool.toArray().length));
    }

    public static void addActiveEvent(World world) {
        int stage = WoNVars.worldVariables.getInvasionLevel(world);
        if (InvasionEvents.getEventPool(stage).isEmpty()) {
            return;
        }
        int clearSlot = WoNVars.worldVariables.get(world).getClearQueueSlot();
        if (clearSlot != 0) {
            InvasionEvent event = InvasionEvents.pullEventFromPool(stage);
            WoNVars.worldVariables.get((World)world).activeEvents.add(event);
            WoNVars.worldVariables.get(world).queueEvent(world, clearSlot, event.getEventFormat());
            WyrmsOfNyrus.logger.debug(String.format("Invasion event saved to world NBT as: %s", event.getEventFormat()));
        } else {
            WyrmsOfNyrus.logger.warn("Tried to queue an event, but the world/dimension queue is already full.");
        }
    }

    public static void addOverrideEvent(World world, int slot, String format) {
        String[] sList = format.split(",");
        ArrayList<Integer> iList = new ArrayList<Integer>();
        for (String s : sList) {
            iList.add(Integer.parseInt(s));
        }
        InvasionEvent e = InvasionEvents.getEvent((Integer)iList.get(0));
        if (e == null) {
            WyrmsOfNyrus.logger.error("Tried to put an invalid event int the queue");
            return;
        }
        e.buildFromEventFormat(format);
        WoNVars.worldVariables.get((World)world).activeEvents.add(e);
        WoNVars.worldVariables.get(world).queueEventOveride(world, slot, e.getEventFormat());
        WyrmsOfNyrus.logger.debug(String.format("Invasion event saved to world NBT as [%s] in slot %d", e.getEventFormat(), slot));
    }

    public static void readEventQueue(World world) {
        if (!WoNVars.worldVariables.get(world).emptyQueue()) {
            ArrayList<String> q = WoNVars.worldVariables.get(world).getQueueFromWorld();
            for (String eventStr : q) {
                WyrmsOfNyrus.logger.debug("Reading queue slot: " + eventStr);
                if (!eventStr.equalsIgnoreCase("empty")) {
                    WyrmsOfNyrus.logger.debug("Found an event in the queue");
                    String[] sList = eventStr.split(",");
                    ArrayList<Integer> iList = new ArrayList<Integer>();
                    for (String s : sList) {
                        iList.add(Integer.parseInt(s));
                    }
                    InvasionEvent e = InvasionEvents.getEvent((Integer)iList.get(0));
                    if (e == null) {
                        WyrmsOfNyrus.logger.error("Tried to start an invalid event from the queue");
                        return;
                    }
                    e.buildFromEventFormat(eventStr);
                    WoNVars.worldVariables.get((World)world).activeEvents.add(e);
                    continue;
                }
                WyrmsOfNyrus.logger.debug("Queue slot was empty.");
            }
        }
    }

    public static void removeExpiredEvents(World world) {
        if (!WoNVars.worldVariables.get((World)world).activeEvents.isEmpty()) {
            WoNVars.worldVariables.get((World)world).activeEvents.removeIf(event -> !event.getActiveStatus());
        }
    }

    public static void eventRunner(EntityPlayer player, World world) {
        if (!WoNVars.worldVariables.get((World)world).activeEvents.isEmpty()) {
            for (int i = 0; i < WoNVars.worldVariables.get((World)world).activeEvents.size(); ++i) {
                if (WoNVars.worldVariables.get((World)world).activeEvents.get(i) == null) {
                    return;
                }
                InvasionEvent event = WoNVars.worldVariables.get((World)world).activeEvents.get(i);
                if (!event.getActiveStatus()) {
                    event.startEvent(player.func_180425_c(), world);
                }
                event.invasionRuntime(player.func_180425_c(), world);
            }
        }
    }
}

