/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.invasion;

import com.vetpetmon.wyrmsofnyrus.WoNVars;
import net.minecraft.world.World;

public class InvasionPoints {
    private static double pointBuffer;

    public static double get(World w) {
        return WoNVars.worldVariables.get((World)w).wyrmInvasionPoints;
    }

    public static double getDifficulty(World w) {
        return WoNVars.worldVariables.get((World)w).wyrmInvasionDifficulty;
    }

    public static void setDifficulty(World w, float input) {
        WoNVars.worldVariables.get((World)w).wyrmInvasionDifficulty = input;
        InvasionPoints.sync(w);
    }

    public static int getResources(World w) {
        return WoNVars.worldVariables.get((World)w).wyrmResources;
    }

    public static void add(World w, int i) {
        if (i <= 0) {
            return;
        }
        if ((pointBuffer += (double)i) >= 1.0) {
            InvasionPoints.updatePoints(w, pointBuffer);
        }
    }

    public static void add(World w, double i) {
        if ((pointBuffer += i) >= 1.0) {
            InvasionPoints.updatePoints(w, pointBuffer);
        }
    }

    public static void updatePoints(World w, double buffer) {
        WoNVars.worldVariables.get((World)w).wyrmInvasionPoints += (double)((int)buffer);
        pointBuffer = 0.0;
        InvasionPoints.sync(w);
    }

    public static void addResources(World w, int buffer) {
        WoNVars.worldVariables.get((World)w).wyrmResources += buffer;
        InvasionPoints.sync(w);
    }

    public static void removeResources(World w, int buffer) {
        WoNVars.worldVariables.get((World)w).wyrmResources -= buffer;
        InvasionPoints.sync(w);
    }

    public static void subtract(World w, int i) {
        WoNVars.worldVariables.get((World)w).wyrmInvasionPoints -= (double)i;
        InvasionPoints.sync(w);
    }

    public static void subtract(World w, double i) {
        WoNVars.worldVariables.get((World)w).wyrmInvasionPoints -= i;
        InvasionPoints.sync(w);
    }

    private static void sync(World w) {
        WoNVars.worldVariables.get(w).syncData(w);
    }
}

