/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.invasion;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WoNVars;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.config.WorldConfig;
import net.minecraft.world.World;

public class InvasionScheduler {
    private static int nextDay = 0;
    private static int nextHalfDay = 0;
    private static int nextEventTime = 0;
    private static int currentDay;
    private static int currentHalfDay;
    private static int currentEventTime;

    public static int getWorldDays(World world) {
        return (int)Math.floor((int)(world.func_72820_D() / (long)WorldConfig.ticksPerDay));
    }

    public static int getWorldHalfDays(World world) {
        return (int)Math.floor((int)(world.func_72820_D() / (long)WorldConfig.ticksPerDay));
    }

    public static int getWorldSchedule(World world) {
        return (int)Math.floor((int)(world.func_82737_E() / (long)(Invasion.invasionEventFrequency * 1200)));
    }

    public static int getWorldQuarterDays(World world) {
        return (int)Math.floor((int)(world.func_72820_D() / (long)WorldConfig.ticksPerDay));
    }

    public static int getCurrentHalfDay() {
        return currentHalfDay;
    }

    public static boolean invasionStartCondition() {
        WyrmsOfNyrus.logger.debug("invasionStartTime is " + Invasion.invasionStartTime + ".");
        WyrmsOfNyrus.logger.debug("invasionStartChance is " + Invasion.invasionStartChance + ".");
        if (Invasion.invasionStartMode > 1) {
            return currentDay >= Invasion.invasionStartTime && RNG.getIntRangeInclu((int)0, (int)Invasion.invasionStartChance) == 1;
        }
        if (Invasion.invasionStartMode == 1) {
            return currentDay >= Invasion.invasionStartTime;
        }
        return RNG.getIntRangeInclu((int)0, (int)Invasion.invasionStartChance) == 1;
    }

    public static boolean detectDayChange(World world) {
        currentDay = InvasionScheduler.getWorldDays(world);
        if (nextDay > currentDay + 1) {
            nextDay = currentDay;
        } else if (currentDay >= nextDay) {
            nextDay = currentDay + 1;
            WyrmsOfNyrus.logger.debug("Day changed detected, current day is now " + currentDay + ".");
            WyrmsOfNyrus.logger.debug("Day changed detected, next day is now " + nextDay + ".");
            return true;
        }
        return false;
    }

    public static boolean detectHalfDayChange(World world) {
        currentHalfDay = InvasionScheduler.getWorldHalfDays(world);
        if (nextHalfDay > currentHalfDay + 1) {
            nextHalfDay = currentHalfDay;
        } else if (currentHalfDay >= nextHalfDay) {
            nextHalfDay = currentHalfDay + 1;
            WyrmsOfNyrus.logger.debug("Half-day changed detected, current half-day is now " + currentHalfDay + ".");
            WyrmsOfNyrus.logger.debug("Half-day changed detected, next half-day is now " + nextHalfDay + ".");
            return true;
        }
        return false;
    }

    public static boolean runSchedule(World world) {
        InvasionScheduler.getScheduler(world);
        if (nextEventTime != currentEventTime + 1) {
            nextEventTime = currentEventTime + 1;
            InvasionScheduler.setScheduler(world);
        }
        if (nextEventTime > (currentEventTime = InvasionScheduler.getWorldSchedule(world)) + 1) {
            nextEventTime = currentEventTime;
        } else if (currentEventTime >= nextEventTime) {
            nextEventTime = currentEventTime + 1;
            InvasionScheduler.setScheduler(world);
            WyrmsOfNyrus.logger.debug("Current Event time schedule: " + currentEventTime + ".");
            WyrmsOfNyrus.logger.debug("Next Event scheduled for: " + nextEventTime + ".");
            return true;
        }
        return false;
    }

    public static void getScheduler(World w) {
        currentEventTime = WoNVars.worldVariables.get((World)w).eventSchedulerCurrentInstance;
        nextEventTime = WoNVars.worldVariables.get((World)w).eventSchedulerNextInstance;
        if (currentEventTime > InvasionScheduler.getWorldSchedule(w)) {
            WoNVars.worldVariables.get((World)w).eventSchedulerCurrentInstance = InvasionScheduler.getWorldSchedule(w);
            WoNVars.worldVariables.get(w).syncData(w);
            InvasionScheduler.getScheduler(w);
        }
    }

    private static void setScheduler(World w) {
        WoNVars.worldVariables.get((World)w).eventSchedulerCurrentInstance = currentEventTime;
        WoNVars.worldVariables.get((World)w).eventSchedulerNextInstance = nextEventTime;
        WoNVars.worldVariables.get(w).syncData(w);
    }
}

