/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.item;

import com.vetpetmon.synlib.client.rendering.IHasModel;
import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.entity.EntityWyrm;
import com.vetpetmon.wyrmsofnyrus.entity.MobEntityBase;
import com.vetpetmon.wyrmsofnyrus.entity.WyrmRegister;
import com.vetpetmon.wyrmsofnyrus.entity.creeped.EntityCreepPod;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityCallousPod;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityHexePod;
import com.vetpetmon.wyrmsofnyrus.entity.wyrms.EntityTheVisitor;
import com.vetpetmon.wyrmsofnyrus.item.AllItems;
import com.vetpetmon.wyrmsofnyrus.item.ItemBase;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WyrmSpawner
extends ItemBase
implements IHasModel {
    private int type;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public WyrmSpawner(String name, int ty) {
        this(name, ty, false);
    }

    public WyrmSpawner(String name, int ty, boolean disabled) {
        super(name, true, disabled);
        if (disabled) {
            AllItems.ALL_ITEMS.remove((Object)this);
        }
        this.setType(ty);
        this.field_77777_bU = 1;
    }

    public String func_77658_a() {
        return "entity." + WyrmRegister.wyrmIDs[this.getType()][0];
    }

    public String func_77667_c(ItemStack stack) {
        return "entity." + WyrmRegister.wyrmIDs[this.getType()][0];
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)("tooltip.won." + this.func_77658_a()), (Object[])new Object[0]));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        EntityLiving spawn = WyrmSpawner.toSpawn(this.getType(), worldIn);
        double yPos = pos.func_177956_o() + 1;
        if (spawn instanceof EntityHexePod || spawn instanceof EntityCreepPod || spawn instanceof EntityCallousPod) {
            yPos += 80.0;
        } else if (spawn instanceof EntityTheVisitor) {
            yPos += 50.0;
        }
        spawn.func_70012_b((double)pos.func_177958_n() + 0.5, yPos, (double)pos.func_177952_p() + 0.5, worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!worldIn.field_72995_K) {
            spawn.func_180482_a(worldIn.func_175649_E(pos), null);
            worldIn.func_72838_d((Entity)spawn);
        }
        WyrmSpawner.onUseShrink(player, hand);
        return EnumActionResult.SUCCESS;
    }

    private static EntityLiving toSpawn(int eType, World worldIn) {
        MobEntityBase wyrmEntity = null;
        EntitySpider entity = new EntitySpider(worldIn);
        if (Objects.equals(WyrmRegister.wyrmIDs[eType][1], "true")) {
            if (EntityList.func_188429_b((ResourceLocation)new ResourceLocation("wyrmsofnyrus", WyrmRegister.wyrmIDs[eType][0]), (World)worldIn) instanceof EntityWyrm) {
                wyrmEntity = (EntityWyrm)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("wyrmsofnyrus", WyrmRegister.wyrmIDs[eType][0]), (World)worldIn);
            }
        } else {
            WyrmsOfNyrus.logger.warn("Tried to spawn an entity that doesn't currently exist in registry. Did you disable it?");
        }
        if (wyrmEntity != null) {
            wyrmEntity.setVariant(RNG.getIntRange((int)0, (int)wyrmEntity.getLegalVariantsLength()));
            return wyrmEntity;
        }
        return entity;
    }

    public static void onUseShrink(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            is.func_190918_g(1);
            if (is.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
        }
    }
}

