/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.locallib;

import com.vetpetmon.synlib.core.util.CFG;
import com.vetpetmon.wyrmsofnyrus.entity.WyrmRegister;
import com.vetpetmon.wyrmsofnyrus.locallib.StatType;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;

public class MobStatConfigs {
    private float[] statArray = new float[20];
    private boolean[] toggleArray = new boolean[5];

    private String getStatName(StatType type) {
        switch (type) {
            case SPECIALATK: {
                return "Special Attack";
            }
            case SPECIALSPEED: {
                return "Special Speed";
            }
            case BREAKSTRENGTH: {
                return "Block Breaking Strength";
            }
            case STATUSLEVEL: {
                return "Applied Status Level";
            }
            case KBR: {
                return "Knockback Resistance";
            }
        }
        return String.format("%s", StringUtils.capitalize((String)StringUtils.lowerCase((String)String.valueOf((Object)type))));
    }

    private String getToggleName(ToggleConfigs type) {
        switch (type) {
            case CANBREAKBLOCKS: {
                return "Can Break Blocks";
            }
            case CANSPREADCREEP: {
                return "Can Spread Hive Creep";
            }
        }
        return String.format("%s", StringUtils.capitalize((String)StringUtils.lowerCase((String)String.valueOf((Object)type))));
    }

    private static String getDefaults(float preset) {
        return String.format("Default: %f", Float.valueOf(preset));
    }

    private static String getDefaults(boolean preset) {
        return String.format("Default: %b", preset);
    }

    public float getStat(StatType stat) {
        return this.statArray[stat.ordinal()];
    }

    public boolean getToggle(ToggleConfigs togg) {
        return this.toggleArray[togg.ordinal()];
    }

    public void makeConfigs(Configuration c, int mobID, float[][] presetDefaults, boolean[][] togglesDefaults, int presetID) {
        String CAT = String.format("%s base stats", WyrmRegister.getMobName(mobID));
        c.addCustomCategoryComment(CAT, String.format("\nStats for the %s.\n", WyrmRegister.getMobName(mobID)));
        if (presetID > 2) {
            presetID = 0;
        }
        for (StatType statType : StatType.values()) {
            this.statArray[statType.ordinal()] = presetDefaults[statType.ordinal()][0] >= 0.0f ? CFG.createConfigDouble((Configuration)c, (String)CAT, (String)this.getStatName(statType), (String)MobStatConfigs.getDefaults(presetDefaults[statType.ordinal()][presetID]), (double)presetDefaults[statType.ordinal()][presetID]) : 0.0f;
        }
        for (Enum enum_ : ToggleConfigs.values()) {
            this.toggleArray[enum_.ordinal()] = CFG.createConfigBool((Configuration)c, (String)CAT, (String)this.getToggleName((ToggleConfigs)enum_), (String)MobStatConfigs.getDefaults(togglesDefaults[enum_.ordinal()][presetID]), (boolean)togglesDefaults[enum_.ordinal()][presetID]);
        }
    }

    public void createBlankDefaults() {
        for (StatType statType : StatType.values()) {
            this.statArray[statType.ordinal()] = 0.0f;
        }
        for (Enum enum_ : ToggleConfigs.values()) {
            this.toggleArray[enum_.ordinal()] = true;
        }
    }

    public static enum ToggleConfigs {
        ENABLED,
        CANBREAKBLOCKS,
        CANSPREADCREEP;

    }
}

