/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.world.biome;

import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.config.WorldConfig;
import com.vetpetmon.wyrmsofnyrus.world.biome.BiomeRegistry;
import com.vetpetmon.wyrmsofnyrus.world.structures.StructureConstruct;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class SpreadingBiome {
    public static void setBiome(World w, BlockPos pos, Biome biome) {
        if (biome != null) {
            int convX = pos.func_177958_n() & 0xF;
            int convZ = pos.func_177952_p() & 0xF;
            w.func_175726_f((BlockPos)pos).func_76605_m()[convZ << 4 | convX] = (byte)Biome.func_185362_a((Biome)biome);
        }
    }

    public static void setBiome(World w, BlockPos pos) {
        int convX = pos.func_177958_n() & 0xF;
        int convZ = pos.func_177952_p() & 0xF;
        Chunk c = w.func_175726_f(pos);
        byte[] i = c.func_76605_m();
        byte id = i[convZ << 4 | convX];
        if (!BiomeRegistry.CreepedBiomes.contains(id)) {
            i[convZ << 4 | convX] = w.func_180494_b(pos).func_76727_i() >= 0.56f ? (byte)Biome.func_185362_a((Biome)BiomeRegistry.HEXEDGARDEN) : (w.func_180494_b(pos).func_180626_a(pos) <= 0.2f ? (byte)Biome.func_185362_a((Biome)BiomeRegistry.COOLEDCREEPLANDS) : (byte)Biome.func_185362_a((Biome)BiomeRegistry.CREEPLANDS));
        }
    }

    public static BlockPos getOpenPosition(World w, BlockPos pos) {
        return SpreadingBiome.getOpenPosition(w, pos, 3);
    }

    public static BlockPos getOpenPosition(World w, BlockPos pos, int tries) {
        if (w.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150350_a && w.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return pos;
        }
        return tries <= 1 ? null : SpreadingBiome.getOpenPosition(w, w.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a ? pos.func_177984_a() : pos.func_177977_b(), --tries);
    }

    public static void createCreepedStructure(World w, BlockPos pos, Random rand) {
        if (w.func_180495_p(pos).func_185904_a() != Material.field_151586_h && rand.nextFloat() < WorldConfig.hiveCreepStructureDenisity) {
            int num = RNG.getIntRangeInclu((int)1, (int)22);
            StructureConstruct structure = new StructureConstruct("creepedlands/hivecreepstructure" + num, true);
            structure.func_180709_b(w, rand, pos);
        }
    }

    public static void createHexedStructure(World w, BlockPos pos, Random rand) {
        if (w.func_180495_p(pos).func_185904_a() != Material.field_151586_h && rand.nextFloat() < WorldConfig.hiveCreepStructureDenisity * 2.0f) {
            int num = RNG.getIntRangeInclu((int)1, (int)13);
            StructureConstruct structure = new StructureConstruct("creepedlands/hexedgarden" + num, true);
            structure.func_180709_b(w, rand, pos);
        }
    }

    public static void createCoolantStructure(World w, BlockPos pos, Random rand) {
        if (w.func_180495_p(pos).func_185904_a() != Material.field_151586_h && rand.nextFloat() < WorldConfig.hiveCreepStructureDenisity * 2.0f) {
            int num = RNG.getIntRangeInclu((int)1, (int)4);
            StructureConstruct structure = new StructureConstruct("creepedlands/coolant" + num, true);
            structure.func_180709_b(w, rand, pos);
        }
    }
}

