/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.achievement_quest_tab;

import com.ringoway.achievement_quest_tab.api.ColorUtil;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="achievement_quest_tab", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AQTConfig {
    public static final String DEFAULT_ACHIEVEMENT_EMOJI = "\ud83c\udfc6";
    public static final String DEFAULT_QUEST_EMOJI = "\ud83c\udfaf";
    public static final boolean DEFAULT_SHOW_IN_TAB = true;
    public static final String DEFAULT_ACHIEVEMENT_COLOR = "#FFD700";
    public static final String DEFAULT_QUEST_COLOR = "#00FFFF";
    public static final String DEFAULT_BRACKETS_COLOR = "#808080";
    public static ForgeConfigSpec.BooleanValue SHOW_IN_F3;
    public static ForgeConfigSpec.BooleanValue F3_SHOW_ACHIEVEMENTS;
    public static ForgeConfigSpec.BooleanValue F3_SHOW_QUESTS;
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue SHOW_IN_TAB;
    public static ForgeConfigSpec.ConfigValue<String> ACHIEVEMENT_EMOJI;
    public static ForgeConfigSpec.ConfigValue<String> QUEST_EMOJI;
    public static ForgeConfigSpec.ConfigValue<String> ACHIEVEMENT_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> QUEST_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> BRACKETS_COLOR;
    public static int achievementColorValue;
    public static int questColorValue;
    public static int bracketsColorValue;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        achievementColorValue = ColorUtil.parseHexColor((String)ACHIEVEMENT_COLOR.get());
        questColorValue = ColorUtil.parseHexColor((String)QUEST_COLOR.get());
        bracketsColorValue = ColorUtil.parseHexColor((String)BRACKETS_COLOR.get());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Settings for controlling the display of progress in the tab list.").push("display");
        SHOW_IN_TAB = builder.comment("Whether to show achievement and quest progress in the player tab list.").define("showInTab", true);
        builder.pop();
        builder.comment("Emoji settings for the tab list.").push("emoji");
        ACHIEVEMENT_EMOJI = builder.comment("Emoji for achievements.").define("achievementEmoji", (Object)DEFAULT_ACHIEVEMENT_EMOJI);
        QUEST_EMOJI = builder.comment("Emoji for quests.").define("questEmoji", (Object)DEFAULT_QUEST_EMOJI);
        builder.pop();
        builder.comment("Color settings for the tab list. Use HEX format (#RRGGBB).").push("colors");
        ACHIEVEMENT_COLOR = builder.comment("Color for achievements counter in HEX format (#RRGGBB).").define("achievementColor", (Object)DEFAULT_ACHIEVEMENT_COLOR);
        QUEST_COLOR = builder.comment("Color for quests counter in HEX format (#RRGGBB).").define("questColor", (Object)DEFAULT_QUEST_COLOR);
        BRACKETS_COLOR = builder.comment("Color for brackets and separators in HEX format (#RRGGBB).").define("bracketsColor", (Object)DEFAULT_BRACKETS_COLOR);
        builder.pop();
        builder.comment("Settings for F3 debug screen display.").push("f3_display");
        SHOW_IN_F3 = builder.comment("Whether to show achievement and quest progress in F3 debug screen.").define("showInF3", true);
        F3_SHOW_ACHIEVEMENTS = builder.comment("Whether to show achievements count in F3.").define("f3ShowAchievements", true);
        F3_SHOW_QUESTS = builder.comment("Whether to show quests count in F3.").define("f3ShowQuests", true);
        builder.pop();
        SPEC = builder.build();
    }
}

