/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.achievement_quest_tab;

import com.mojang.logging.LogUtils;
import com.ringoway.achievement_quest_tab.AQTConfig;
import com.ringoway.achievement_quest_tab.api.cache.CacheRefresher;
import com.ringoway.achievement_quest_tab.api.cache.QuestProgressCache;
import com.ringoway.achievement_quest_tab.event.AdvancementEventHandler;
import com.ringoway.achievement_quest_tab.event.TabListEventHandler;
import com.ringoway.achievement_quest_tab.event.ftb.TeamEventsHandler;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="achievement_quest_tab")
public class AchievementQuestTab {
    public static final String MOD_ID = "achievement_quest_tab";
    public static final Logger LOGGER = LogUtils.getLogger();

    public AchievementQuestTab(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)new AdvancementEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TabListEventHandler());
        if (AchievementQuestTab.isFTBTeamsLoaded()) {
            LOGGER.info("FTB Teams detected. Registering team event handlers.");
            TeamEvent.PLAYER_JOINED_PARTY.register(TeamEventsHandler::onPlayerJoinedTeam);
            TeamEvent.PLAYER_CHANGED.register(TeamEventsHandler::onPlayerChangedTeam);
            TeamEvent.PLAYER_LEFT_PARTY.register(TeamEventsHandler::onPlayerLeftTeam);
            TeamEvent.PLAYER_LOGGED_IN.register(TeamEventsHandler::onPlayerLoggedInAfterTeam);
            TeamEvent.CREATED.register(TeamEventsHandler::onTeamCreated);
        }
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AQTConfig.SPEC, "achievement_quest_tab.toml");
        modEventBus.addListener(AQTConfig::onLoad);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Achievement Quest Tab common setup");
        if (AchievementQuestTab.isFTBQuestsLoaded()) {
            LOGGER.info("FTB Quests detected. Enabling quest tracking.");
            ObjectCompletedEvent.QUEST.register(this::onFTBQuestCompleted);
        } else {
            LOGGER.info("FTB Quests not found. Only vanilla achievements will be tracked.");
        }
    }

    private EventResult onFTBQuestCompleted(ObjectCompletedEvent.QuestEvent event) {
        QuestProgressCache.updateCache(event.getData());
        for (ServerPlayer player : event.getOnlineMembers()) {
            CacheRefresher.refreshPlayer(player);
        }
        return EventResult.pass();
    }

    public static boolean isFTBQuestsLoaded() {
        return ModList.get().isLoaded("ftbquests");
    }

    public static boolean isFTBTeamsLoaded() {
        return ModList.get().isLoaded("ftbteams");
    }
}

