/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.achievement_quest_tab.api.cache;

import com.ringoway.achievement_quest_tab.AchievementQuestTab;
import com.ringoway.achievement_quest_tab.api.cache.QuestProgressCache;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CacheRefresher {
    public static void refreshPlayer(ServerPlayer player) {
        TeamData teamData;
        if (player == null) {
            return;
        }
        if (AchievementQuestTab.isFTBQuestsLoaded() && (teamData = TeamData.get((Player)player)) != null) {
            QuestProgressCache.updateCache(teamData);
        }
        player.refreshTabListName();
    }

    public static void refreshTeam(Team team) {
        if (team == null) {
            return;
        }
        if (AchievementQuestTab.isFTBQuestsLoaded()) {
            team.getOnlineMembers().stream().findFirst().ifPresent(player -> {
                TeamData teamData = TeamData.get((Player)player);
                if (teamData != null) {
                    QuestProgressCache.updateCache(teamData);
                }
            });
        }
        for (ServerPlayer member : team.getOnlineMembers()) {
            member.refreshTabListName();
        }
        AchievementQuestTab.LOGGER.debug("Refreshed team: {} ({} online members)", (Object)team.getName().getString(), (Object)team.getOnlineMembers().size());
    }

    public static void refreshAll(ServerLevel level) {
        if (AchievementQuestTab.isFTBQuestsLoaded()) {
            QuestProgressCache.initializeAll();
        }
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            CacheRefresher.refreshPlayer(player);
        }
    }

    public static void refreshAll(ServerLevel level, Consumer<ServerPlayer> callback) {
        if (AchievementQuestTab.isFTBQuestsLoaded()) {
            QuestProgressCache.initializeAll();
        }
        level.m_7654_().m_6846_().m_11314_().forEach(player -> {
            CacheRefresher.refreshPlayer(player);
            callback.accept((ServerPlayer)player);
        });
    }
}

