/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.achievement_quest_tab.api.cache;

import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class QuestProgressCache {
    private static final ConcurrentMap<UUID, Integer> TEAM_COMPLETED_CACHE = new ConcurrentHashMap<UUID, Integer>();

    public static int getCompletedQuests(ServerPlayer player) {
        if (player == null || ServerQuestFile.INSTANCE == null) {
            return 0;
        }
        TeamData teamData = TeamData.get((Player)player);
        if (teamData == null) {
            return 0;
        }
        return TEAM_COMPLETED_CACHE.getOrDefault(teamData.getTeamId(), 0);
    }

    public static void updateCache(TeamData teamData) {
        if (ServerQuestFile.INSTANCE == null || teamData == null) {
            return;
        }
        AtomicInteger ai = new AtomicInteger(0);
        ServerQuestFile.INSTANCE.forAllQuests(q -> {
            if (teamData.isCompleted((QuestObject)q)) {
                ai.incrementAndGet();
            }
        });
        TEAM_COMPLETED_CACHE.put(teamData.getTeamId(), ai.get());
    }

    public static void initializeAll() {
        if (ServerQuestFile.INSTANCE == null) {
            return;
        }
        TEAM_COMPLETED_CACHE.clear();
        ServerQuestFile.INSTANCE.getAllTeamData().forEach(QuestProgressCache::updateCache);
    }

    public static void clear() {
        TEAM_COMPLETED_CACHE.clear();
    }
}

