/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.achievement_quest_tab.api.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerProgressData
extends SavedData {
    private final Set<ResourceLocation> processed = new HashSet<ResourceLocation>();
    private final Map<UUID, Integer> playerAchievements = new HashMap<UUID, Integer>();

    public static PlayerProgressData load(CompoundTag tag) {
        PlayerProgressData data = new PlayerProgressData();
        CompoundTag achievements = tag.m_128469_("PlayerAchievements");
        for (String key : achievements.m_128431_()) {
            data.playerAchievements.put(UUID.fromString(key), achievements.m_128451_(key));
        }
        ListTag list = tag.m_128437_("Processed", 8);
        for (Tag t : list) {
            data.processed.add(ResourceLocation.m_135820_((String)((StringTag)t).m_7916_()));
        }
        return data;
    }

    public static PlayerProgressData get(ServerLevel level) {
        if (level == null || level.m_7654_() == null) {
            return new PlayerProgressData();
        }
        ServerLevel overworld = level.m_7654_().m_129783_();
        if (overworld == null) {
            return new PlayerProgressData();
        }
        return (PlayerProgressData)overworld.m_8895_().m_164861_(PlayerProgressData::load, PlayerProgressData::new, "player_progress_data");
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag achievements = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : this.playerAchievements.entrySet()) {
            achievements.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("PlayerAchievements", (Tag)achievements);
        ListTag list = new ListTag();
        for (ResourceLocation id : this.processed) {
            list.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        tag.m_128365_("Processed", (Tag)list);
        return tag;
    }

    public void incrementPlayerAchievements(UUID playerId) {
        this.playerAchievements.put(playerId, this.playerAchievements.getOrDefault(playerId, 0) + 1);
        this.m_77762_();
    }

    public int getPlayerAchievements(UUID playerId) {
        return this.playerAchievements.getOrDefault(playerId, 0);
    }

    public boolean isMarkerProcessed(ResourceLocation id) {
        return this.processed.contains(id);
    }

    public void markMarkerAsProcessed(ResourceLocation id) {
        this.processed.add(id);
        this.m_77762_();
    }
}

