/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class AutoJoinGroupStore {
    private final File file;
    private final Gson gson;
    private StoreContent content;

    public AutoJoinGroupStore(File file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.content = new StoreContent();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            EnhancedGroups.LOGGER.error("Failed to load auto join groups");
            return;
        }
        this.migrate(this.file);
        try (FileReader reader = new FileReader(this.file);){
            Type contentType = new TypeToken<StoreContent>(this){}.getType();
            this.content = (StoreContent)this.gson.fromJson((Reader)reader, contentType);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to parse auto join groups", (Throwable)e);
        }
        if (this.content == null) {
            this.content = new StoreContent();
        }
    }

    private void migrate(File file) {
        try (FileReader reader = new FileReader(file);){
            Type playerGroupsType = new TypeToken<Map<UUID, UUID>>(this){}.getType();
            Map playerGroups = (Map)this.gson.fromJson((Reader)reader, playerGroupsType);
            EnhancedGroups.LOGGER.info("Migrated config");
            this.content = new StoreContent();
            this.content.playerGroups = playerGroups;
            this.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson((Object)this.content, (Appendable)writer);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to save auto join groups", (Throwable)e);
        }
    }

    @Nullable
    public UUID getPlayerGroup(UUID playerUuid) {
        return this.content.playerGroups.get(playerUuid);
    }

    public void setPlayerGroup(UUID playerUuid, UUID groupId) {
        this.content.playerGroups.put(playerUuid, groupId);
        this.save();
    }

    public void removePlayerGroup(UUID playerUuid) {
        this.content.playerGroups.remove(playerUuid);
        this.save();
    }

    @Nullable
    public UUID getGlobalGroup() {
        return this.content.globalGroup;
    }

    public void setGlobalGroup(UUID groupId) {
        this.content.globalGroup = groupId;
        this.save();
    }

    public void removeGlobalGroup() {
        this.content.globalGroup = null;
        this.save();
    }

    public boolean getGlobalGroupForced() {
        return this.content.globalGroupForced;
    }

    public void setGlobalGroupForced(boolean status) {
        this.content.globalGroupForced = status;
        this.save();
    }

    private static class StoreContent {
        public Map<UUID, UUID> playerGroups = new HashMap<UUID, UUID>();
        public UUID globalGroup = null;
        public boolean globalGroupForced = false;

        StoreContent() {
        }
    }
}

