{
  id: "blackflamedominion",
  name: "Black Flame Dominion",
  rating: 6,
  num: 9025,
  flags: {mirror: 1},

  onStart(pokemon) {
    this.add('-ability', pokemon, 'Black Flame Dominion');
    this.add(`The sky darkens… black flames consume the battlefield.`);
    pokemon.blackFlameTurns = 0;
  },

  onResidual(pokemon) {
    if (typeof pokemon.blackFlameTurns === 'number') {
      pokemon.blackFlameTurns++;

      if (pokemon.blackFlameTurns === 3) {
        for (const foe of pokemon.side.foe.active) {
          if (foe && !foe.fainted && !foe.status) {
            foe.trySetStatus('brn', pokemon);
            this.add(`${foe.name} was scorched by the cursed flames!`);
          }
        }
      }
    }
  },

  onBasePower(basePower, attacker, defender, move) {
    if (
      attacker.hasAbility('blackflamedominion') &&
      ['Fire', 'Dark'].includes(move.type)
    ) {
      return this.chainModify(1.5);
    }
  },

  onAnyAccuracy(accuracy, target, source, move) {
    const user = this.effectState.target;
    if (!user || user.fainted || !user.isActive) return;
    if (source && source.side !== user.side) {
      return this.chainModify(0.5);
    }
  }
}
