{
  id: "eternalember",
  name: "Eternal Ember",
  rating: 6,
  num: 9021,
  flags: {mirror: 1},

  onResidual(pokemon) {
    for (const foe of pokemon.side.foe.active) {
      if (foe && !foe.fainted && foe.hasType('Fire')) {
        this.add('-ability', pokemon, 'Eternal Ember');
        this.add(`${pokemon.name}'s Eternal Ember devoured ${foe.name}'s flame—and its life.`);
        foe.faint();
      }
    }
  },

  onAfterMove(source, target, move) {
    if (!move || move.category === 'Status') return;
    if (move.type !== 'Fire') return;
    if (!target || target.fainted || target.status) return;

    target.trySetStatus('brn', source, move);
  },

  onDamagePriority: 1,
  onDamage(damage, target, source, effect) {
    if (
      target.hasAbility('eternalember') &&
      damage >= target.hp &&
      this.getAllActive().some(p => p.side !== target.side && p.status === 'brn')
    ) {
      return target.hp - 1;
    }
  }
}
