{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Raging Inferno");
    this.add(`${pokemon.name}'s black flames flicker to life…`);
    pokemon.failsafe20 = false;
    pokemon.failsafe40 = false;
    pokemon.failsafe60 = false;
  },

  onResidual(pokemon) {
    const lost = 1 - pokemon.hp / pokemon.maxhp;
    if (!pokemon.failsafe20 && lost >= 0.2) {
      this.boost({atk:1, spa:1}, pokemon);
      this.add("Crimson fury ignites!");
      pokemon.failsafe20 = true;
    }
    if (!pokemon.failsafe40 && lost >= 0.4) {
      this.boost({atk:1, spa:1}, pokemon);
      this.add("Blazing inferno surges!");
      pokemon.failsafe40 = true;
    }
    if (!pokemon.failsafe60 && lost >= 0.6) {
      this.boost({atk:1, spa:1}, pokemon);
      this.add("Raging Inferno reaches its peak!");
      pokemon.failsafe60 = true;
    }
  },

  onBasePowerPriority: 23,
  onBasePower(basePower, attacker, defender, move) {
    if (move.type === 'Fire') {
      return this.chainModify(1.3);
    }
  },

  flags: {mirror:1},
  name: "Raging Inferno",
  rating: 3,
  num: 9020
}
