{
  num: 9001,
  accuracy: 100,
  basePower: 65,
  category: "Physical",
  name: "Burn Away",
  pp: 15,
  priority: 0,
  flags: { contact: 1, protect: 1, mirror: 1 },
  type: "Fire",
  shortDesc: "1.5× power and destroys the target's item.",
  desc: "If the target is holding an item, this move deals 1.5× damage and permanently destroys the item. The item cannot be recovered.",

  onBasePower(basePower, source, target, move) {
    const item = target.getItem();
    if (!this.singleEvent("TakeItem", item, target.itemState, target, target, move, item)) return;
    if (item.id) {
      return this.chainModify(1.5);
    }
  },

  onAfterHit(target, source) {
    if (source.hp) {
      const item = target.takeItem();
      if (item) {
        this.add("-enditem", target, item.name, "[from] move: Burn Away", "[of] " + source);
        this.add(`${target.name}'s ${item.name} was reduced to ashes!`);
      }
    }
  },

  secondary: null,
  target: "normal",
  contestType: "Tough"
}
