/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.tfmgrr.core.datagen;

import com.ringoway.tfmgrr.core.datagen.RBlockLootProvider;
import com.ringoway.tfmgrr.core.datagen.TPBlockStateProvider;
import com.ringoway.tfmgrr.core.datagen.TPItemModelProvider;
import com.ringoway.tfmgrr.core.datagen.recipe.TPRecipeProvider;
import com.ringoway.tfmgrr.core.datagen.tags.RBlockTagsProvider;
import com.ringoway.tfmgrr.core.datagen.tags.RItemTagsProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tfmgrr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TPDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeClient()) {
            TPDataGenerator.addClientProviders(generator, packOutput, existingFileHelper);
        }
        if (event.includeServer()) {
            TPDataGenerator.addServerProviders(generator, packOutput, lookupProvider, existingFileHelper);
        }
    }

    private static void addClientProviders(DataGenerator generator, PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        generator.addProvider(true, (DataProvider)new TPBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new TPItemModelProvider(packOutput, existingFileHelper));
    }

    private static void addServerProviders(DataGenerator generator, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        generator.addProvider(true, (DataProvider)new TPRecipeProvider(packOutput));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RBlockLootProvider::new, LootContextParamSets.f_81421_))));
        RBlockTagsProvider blockTagGenerator = (RBlockTagsProvider)generator.addProvider(true, (DataProvider)new RBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new RItemTagsProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
    }
}

