/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.tfmgrr.core.registry;

import com.ringoway.tfmgrr.TFMGRenewableResources;
import com.ringoway.tfmgrr.common.fluid.AcidFluidType;
import com.ringoway.tfmgrr.common.fluid.HotFluidType;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.apache.commons.lang3.StringUtils;
import org.joml.Vector3f;

public class CRAFluids {
    private static final CreateRegistrate REGISTRATE = TFMGRenewableResources.REGISTRATE;
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SALT_WATER = CRAFluids.fluid("salt_water", 4159204, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BRINE = CRAFluids.fluid("brine", 0xD4D4D4, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CAUSTIC_SODA_SOLUTION = CRAFluids.acidFluid("caustic_soda_solution", 0xF0F0F0, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHLORINE_GAS = CRAFluids.fluid("chlorine_gas", 15267048, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SODIUM_ALUMINATE_SOLUTION = CRAFluids.fluid("sodium_aluminate_solution", 15132410, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> ALUMINUM_HYDROXIDE_SUSPENSIONS = CRAFluids.fluid("aluminum_hydroxide_suspensions", 16119260, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SODA_SOLUTION = CRAFluids.fluid("soda_solution", 0xF0F8FF, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> ALUMINUM_MELT = CRAFluids.hotFluid("aluminum_melt", 0xC0C0C0, new TagKey[0]);

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> fluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)((FluidBuilder)REGISTRATE.fluid(name, CRAFluids.getLocation(name), CRAFluids.getLocationFlow(name), SolidRenderedPlaceableFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(CRAFluids.toHumanReadable(name)).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283919_)).build()).bucket().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{TFMGRenewableResources.id("item/" + name + "_bucket")})).tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> acidFluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)((FluidBuilder)REGISTRATE.fluid(name, CRAFluids.getLocation(name), CRAFluids.getLocationFlow(name), AcidFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(CRAFluids.toHumanReadable(name)).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283919_)).build()).bucket().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{TFMGRenewableResources.id("item/" + name + "_bucket")})).tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> hotFluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)((FluidBuilder)REGISTRATE.fluid(name, CRAFluids.getLocation(name), CRAFluids.getLocationFlow(name), HotFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(CRAFluids.toHumanReadable(name)).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283774_)).build()).bucket().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{TFMGRenewableResources.id("item/" + name + "_bucket")})).tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    public static ResourceLocation getLocation(String name) {
        return TFMGRenewableResources.id("fluid/" + name + "_still");
    }

    public static ResourceLocation getLocationFlow(String name) {
        return TFMGRenewableResources.id("fluid/" + name + "_flow");
    }

    public static String toHumanReadable(String key) {
        String s = key.replaceAll("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        s = StringUtils.normalizeSpace((String)s);
        return s;
    }

    public static void register() {
    }

    public static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        public SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

